/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.flightrecorder.internal.flightrecorderprobe;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.net.MediaType;
import com.ur.polyscope.flightrecorder.FlightRecorderProbe;
import com.ur.polyscope.flightrecorder.FlightRecorderTriggerType;
import com.ur.polyscope.flightrecorder.attachment.AttachmentCollector;
import com.ur.polyscope.flightrecorder.attachment.FlightRecorderAttachment;
import com.ur.polyscope.flightrecorder.attachment.FlightRecorderAttachmentFactory;
import java.io.File;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;

public class ScriptInterpreterModeProbe
implements FlightRecorderProbe {
    private static final String SCRIPT_INTERPRETER_LOGS_PATH = "/tmp/log/urcontrol";
    private static final String SCRIPT_INTERPRETER_LOGS_TARGET_FOLDER_NAME = "interpreter";
    private final FlightRecorderAttachmentFactory attachmentFactory;

    @Inject
    public ScriptInterpreterModeProbe(FlightRecorderAttachmentFactory attachmentFactory) {
        this.attachmentFactory = attachmentFactory;
    }

    public String getName() {
        return "Script Interpreter Probe";
    }

    public void write(PrintStream out) {
    }

    public List<FlightRecorderAttachment> getFileAttachments() {
        AttachmentCollector r = new AttachmentCollector(this.attachmentFactory);
        this.addScriptInterpreterLogFiles(r);
        return r.asList();
    }

    private void addScriptInterpreterLogFiles(AttachmentCollector collector) {
        File[] f = new File(SCRIPT_INTERPRETER_LOGS_PATH).listFiles();
        if (f != null) {
            Iterable matchedLogFiles = Iterables.filter(Arrays.asList(f), (Predicate)new Predicate<File>(){

                public boolean apply(File file) {
                    return file.isFile() && file.getName().startsWith(ScriptInterpreterModeProbe.SCRIPT_INTERPRETER_LOGS_TARGET_FOLDER_NAME);
                }
            });
            for (File eachFile : matchedLogFiles) {
                collector.collect(eachFile, SCRIPT_INTERPRETER_LOGS_TARGET_FOLDER_NAME, MediaType.PLAIN_TEXT_UTF_8.toString());
            }
        }
    }

    public void start() {
    }

    public void stop() {
    }

    public Set<FlightRecorderTriggerType> getApplicableReportTypes() {
        return EnumSet.allOf(FlightRecorderTriggerType.class);
    }
}

