/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.flightrecorder.internal.flightrecorderprobe;

import com.google.common.net.MediaType;
import com.ur.polyscope.flightrecorder.FlightRecorderProbe;
import com.ur.polyscope.flightrecorder.FlightRecorderTriggerType;
import com.ur.polyscope.flightrecorder.attachment.AttachmentCollector;
import com.ur.polyscope.flightrecorder.attachment.FlightRecorderAttachment;
import com.ur.polyscope.flightrecorder.attachment.FlightRecorderAttachmentFactory;
import com.ur.polyscope.flightrecorder.internal.FlightRecorderSettings;
import com.ur.polyscope.platform.api.PlatformEnvironment;
import com.ur.polyscope.platform.api.SoftwarePlatformType;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;

public class SystemProbe
implements FlightRecorderProbe {
    private static final String SYSTEM_FILES_TARGET_FOLDER_NAME = "system";
    private final FlightRecorderSettings settings;
    private final FlightRecorderAttachmentFactory attachmentFactory;

    @Inject
    public SystemProbe(FlightRecorderSettings settings, FlightRecorderAttachmentFactory attachmentFactory) {
        this.settings = settings;
        this.attachmentFactory = attachmentFactory;
    }

    public String getName() {
        return "System Probe";
    }

    public void write(PrintStream s) {
        this.writeStatistics(s);
    }

    private void writeStatistics(PrintStream s) {
        s.println("System Time: " + new Date());
        s.println("Free Memory: " + Runtime.getRuntime().freeMemory());
        s.println("Total Memory: " + Runtime.getRuntime().totalMemory());
        s.println("Max Memory: " + Runtime.getRuntime().maxMemory());
        s.println("System Load Average: " + ManagementFactory.getOperatingSystemMXBean().getSystemLoadAverage());
        s.println("Loaded Class Count: " + ManagementFactory.getClassLoadingMXBean().getLoadedClassCount());
        s.println("Total Loaded Class Count: " + ManagementFactory.getClassLoadingMXBean().getTotalLoadedClassCount());
        s.println("Class Path: " + ManagementFactory.getRuntimeMXBean().getClassPath());
        s.println("Library Path: " + ManagementFactory.getRuntimeMXBean().getLibraryPath());
        s.println("VM Uptime: " + ManagementFactory.getRuntimeMXBean().getUptime());
        s.println("VM Name: " + ManagementFactory.getRuntimeMXBean().getVmName());
        s.println("VM Vendor: " + ManagementFactory.getRuntimeMXBean().getVmVendor());
        s.println("VM Version: " + ManagementFactory.getRuntimeMXBean().getVmVersion());
        s.println();
    }

    private void writeEnvironment(PrintStream s) {
        s.println("Environment:");
        for (Map.Entry<String, String> e : System.getenv().entrySet()) {
            s.println(e.getKey() + "=" + e.getValue());
        }
        s.println();
    }

    private void writeSystemProperties(PrintStream s) {
        s.println("System Properties:");
        for (Map.Entry<Object, Object> e : System.getProperties().entrySet()) {
            s.println(e.getKey() + "=" + e.getValue());
        }
        s.println();
    }

    private void writeThreadDump(PrintStream s) {
        for (Map.Entry<Thread, StackTraceElement[]> e : Thread.getAllStackTraces().entrySet()) {
            Thread t = e.getKey();
            s.format("Thread #%s: %s (%s)%n", new Object[]{t.getId(), t.getName(), t.getState()});
        }
        s.println();
    }

    public List<FlightRecorderAttachment> getFileAttachments() {
        AttachmentCollector r = new AttachmentCollector(this.attachmentFactory);
        r.collect(new File("/var/log/critical"), this.settings.getDefaultFileSizeLimit(), MediaType.PLAIN_TEXT_UTF_8.toString());
        if (PlatformEnvironment.getSoftwarePlatFormType().equals((Object)SoftwarePlatformType.SW6)) {
            r.collect(this.attachmentFactory.getShellCommandAttachment(this.getKernelLogBashCommand(), "kern.log", MediaType.PLAIN_TEXT_UTF_8.toString()));
        } else {
            r.collect(new File("/var/log/kern.log"), this.settings.getDefaultFileSizeLimit(), MediaType.PLAIN_TEXT_UTF_8.toString());
        }
        r.collect(new File("/var/log/Xorg.0.log"), this.settings.getDefaultFileSizeLimit(), MediaType.PLAIN_TEXT_UTF_8.toString());
        r.collect(this.attachmentFactory.getShellCommandAttachment("df -h", "df", MediaType.PLAIN_TEXT_UTF_8.toString()));
        r.collect(this.attachmentFactory.getShellCommandAttachment("ps -eLo pid,tid,class,rtprio,ni,pri,psr,pcpu,stat,wchan:20,comm", "ps", MediaType.PLAIN_TEXT_UTF_8.toString()));
        r.collect(new File("/boot/grub/rescue.log"), SYSTEM_FILES_TARGET_FOLDER_NAME, MediaType.PLAIN_TEXT_UTF_8.toString());
        try {
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            this.writeThreadDump(new PrintStream((OutputStream)b, false, "UTF-8"));
            r.collect(this.attachmentFactory.getByteArrayAttachment(b.toByteArray(), "polyscope.threads.txt", MediaType.PLAIN_TEXT_UTF_8.toString()));
            b = new ByteArrayOutputStream();
            this.writeSystemProperties(new PrintStream((OutputStream)b, false, "UTF-8"));
            this.writeEnvironment(new PrintStream((OutputStream)b, false, "UTF-8"));
            r.collect(this.attachmentFactory.getByteArrayAttachment(b.toByteArray(), "system.environment.txt", MediaType.PLAIN_TEXT_UTF_8.toString()));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return r.asList();
    }

    private String getKernelLogBashCommand() {
        return "journalctl -t kernel --since '2 hours ago'";
    }

    public void start() {
    }

    public void stop() {
    }

    public Set<FlightRecorderTriggerType> getApplicableReportTypes() {
        return EnumSet.allOf(FlightRecorderTriggerType.class);
    }
}

