/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.flightrecorder.internal.reporter;

import com.ur.polyscope.flightrecorder.FlightRecorderReporter;
import com.ur.polyscope.flightrecorder.FlightRecorderTriggerType;
import com.ur.polyscope.flightrecorder.attachment.FlightRecorderAttachment;
import com.ur.polyscope.flightrecorder.internal.FlightRecorderImpl;
import com.ur.polyscope.flightrecorder.internal.FlightRecorderSettings;
import com.ur.polyscope.flightrecorder.internal.reporter.MetadataModel;
import com.ur.polyscope.flightrecorder.internal.reporter.ReportFilesFilter;
import com.ur.polyscope.flightrecorder.internal.reporter.ZipReportWriter;
import com.ur.util.logging.Log;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import javax.inject.Inject;

public class FileSystemReporter
implements FlightRecorderReporter {
    private ZipReportWriter zipReportWriter;
    private ByteArrayOutputStream summaryStream;
    private PrintStream summaryPrintStream;
    private FlightRecorderSettings settings;
    private Set<FlightRecorderAttachment> attachments;
    private MetadataModel metadata;

    @Inject
    FileSystemReporter(FlightRecorderSettings settings) {
        this.settings = settings;
    }

    public PrintStream getWriter() {
        return this.summaryPrintStream;
    }

    public void addAttachments(List<FlightRecorderAttachment> files) {
        this.attachments.addAll(files);
    }

    public void open(String reportId, FlightRecorderTriggerType reportType) {
        this.zipReportWriter = new ZipReportWriter(reportId, this.settings);
        this.summaryStream = new ByteArrayOutputStream();
        try {
            this.summaryPrintStream = new PrintStream((OutputStream)this.summaryStream, false, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.attachments = new HashSet<FlightRecorderAttachment>();
        this.metadata = new MetadataModel();
        this.metadata.setReportId(reportId);
        this.metadata.setReportType(reportType);
        int logFilesLimit = Integer.MAX_VALUE;
        switch (reportType) {
            case CONTROLLER_REPORTED_ERROR: 
            case SOFTWARE_FAILURE: {
                logFilesLimit = this.settings.getMaximumNumberOfReportFiles();
                break;
            }
            case SYSTEM_CONFIGURATION_REPORT: {
                logFilesLimit = 1;
            }
        }
        this.eraseOldestLogs(reportType, logFilesLimit - 1);
    }

    public void close() {
        try {
            this.zipReportWriter.open();
            this.zipReportWriter.writeSummary(this.summaryStream.toByteArray(), this.metadata);
            this.zipReportWriter.writeAttachments(this.attachments, this.metadata);
            this.zipReportWriter.writeMetadata(this.metadata);
        }
        catch (FileNotFoundException ex) {
            Log.error((String)"Could not create FlightRecord zip file", (Throwable)ex);
        }
        catch (IOException ex) {
            Log.error((String)"Could not write to FlightRecord zip file", (Throwable)ex);
        }
        finally {
            try {
                this.zipReportWriter.close();
                Log.info((String)"Zipping of FlightRecord finished");
            }
            catch (IOException ex) {
                Log.error((String)"Could not close FlightRecord zip file", (Throwable)ex);
            }
        }
    }

    private void eraseOldestLogs(FlightRecorderTriggerType forReportType, int limit) {
        File[] filesToDelete;
        File[] reportFiles = this.getReportFiles(EnumSet.of(forReportType));
        if (reportFiles.length <= limit) {
            return;
        }
        Arrays.sort(reportFiles, (left, right) -> left.getName().compareTo(right.getName()));
        for (File f : filesToDelete = Arrays.copyOf(reportFiles, reportFiles.length - limit)) {
            Log.info((String)("Deleting file: " + f.getAbsolutePath()));
            if (f.delete()) continue;
            Log.warning((String)("Can not delete report file: " + f.getName()));
        }
    }

    private File[] getReportFiles(EnumSet<FlightRecorderTriggerType> forReportTypes) {
        File reportsFolder = new File(this.settings.getFlightReportingFolder());
        if (!reportsFolder.exists()) {
            return new File[0];
        }
        HashSet<File> reportFiles = new HashSet<File>();
        for (FlightRecorderTriggerType t : forReportTypes) {
            File[] files = reportsFolder.listFiles(new ReportFilesFilter(t));
            if (files == null) continue;
            reportFiles.addAll(Arrays.asList(files));
        }
        return reportFiles.toArray(new File[0]);
    }

    public Collection<String> getAvailableReports() {
        ArrayList<String> reports = new ArrayList<String>();
        for (File rf : this.getReportFiles(EnumSet.allOf(FlightRecorderTriggerType.class))) {
            Matcher reportIdMatcher = FlightRecorderImpl.flightReportIdentifierPattern.matcher(rf.getName());
            if (!reportIdMatcher.find() || reportIdMatcher.group() == null) continue;
            reports.add(rf.getName().replace(".zip", ""));
        }
        return reports;
    }

    public InputStream getReport(String reportId) {
        for (File rf : this.getReportFiles(EnumSet.allOf(FlightRecorderTriggerType.class))) {
            if (!rf.getName().contains(reportId)) continue;
            try {
                return new FileInputStream(rf);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }
}

