/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.flightrecorder.internal.reporter;

import com.ur.polyscope.flightrecorder.FlightRecorderTriggerType;
import com.ur.polyscope.flightrecorder.internal.FlightRecorderImpl;
import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Pattern;

public class ReportFilesFilter
implements FilenameFilter {
    private final Pattern reportFilePattern;

    ReportFilesFilter(FlightRecorderTriggerType reportType) {
        switch (reportType) {
            case CONTROLLER_REPORTED_ERROR: 
            case SOFTWARE_FAILURE: {
                this.reportFilePattern = Pattern.compile("recording" + FlightRecorderImpl.flightReportIdentifierPattern.pattern() + ".zip");
                break;
            }
            case SYSTEM_CONFIGURATION_REPORT: {
                this.reportFilePattern = Pattern.compile("robot_configuration" + FlightRecorderImpl.flightReportIdentifierPattern.pattern() + ".zip");
                break;
            }
            default: {
                this.reportFilePattern = null;
            }
        }
    }

    @Override
    public boolean accept(File file, String s) {
        return this.reportFilePattern.matcher(s).matches();
    }
}

