/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.flightrecorder.internal.reporter;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.io.CountingOutputStream;
import com.google.common.net.MediaType;
import com.ur.polyscope.flightrecorder.attachment.FlightRecorderAttachment;
import com.ur.polyscope.flightrecorder.internal.FlightRecorderSettings;
import com.ur.polyscope.flightrecorder.internal.reporter.MetadataModel;
import com.ur.util.logging.Log;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;

public class ZipReportWriter {
    private static final String ZIP_FILE_ATTACHMENTS_SUBFOLDER = "files";
    static final String ZIP_FILE_FILE_ENDING = ".zip";
    private static final String SUMMARY_FILE_NAME = "summary.log";
    private static final String METADATA_FILE_NAME = "metadata.json";
    private static final int ZIP_STREAM_BUFFER_SIZE = 102400;
    private final FlightRecorderSettings flightRecorderSettings;
    private final String reportIdentifier;
    private ZipOutputStream zos;

    ZipReportWriter(String reportId, FlightRecorderSettings settings) {
        this.flightRecorderSettings = settings;
        this.reportIdentifier = reportId;
    }

    void open() throws FileNotFoundException {
        String flightRecordingFolderPath = this.flightRecorderSettings.getFlightReportingFolder();
        if (!new File(flightRecordingFolderPath).exists() && !new File(flightRecordingFolderPath).mkdirs()) {
            throw new FileNotFoundException("Failed to create flight report directory at: " + flightRecordingFolderPath);
        }
        FileOutputStream fos = new FileOutputStream(ZipReportWriter.getReportPath(this.reportIdentifier, this.flightRecorderSettings.getFlightReportingFolder()));
        BufferedOutputStream bos = new BufferedOutputStream(fos, 102400);
        this.zos = new ZipOutputStream(bos);
    }

    void writeSummary(byte[] b, MetadataModel metadata) throws IOException {
        if (b == null) {
            return;
        }
        this.zos.putNextEntry(new ZipEntry(SUMMARY_FILE_NAME));
        this.zos.write(b, 0, b.length);
        metadata.addFileInfo(new MetadataModel.FileInfo().setPath(SUMMARY_FILE_NAME).setSize(b.length).setMimeType(MediaType.PLAIN_TEXT_UTF_8.toString()));
    }

    void writeAttachments(Collection<FlightRecorderAttachment> files, MetadataModel metadata) throws IOException {
        if (files == null) {
            return;
        }
        CountingOutputStream osWithCounter = new CountingOutputStream((OutputStream)this.zos);
        for (FlightRecorderAttachment a : files) {
            String name = ZIP_FILE_ATTACHMENTS_SUBFOLDER + File.separator + a.getName();
            try {
                this.zos.putNextEntry(new ZipEntry(name));
                a.write((OutputStream)osWithCounter);
                metadata.addFileInfo(new MetadataModel.FileInfo().setPath(name).setSize(osWithCounter.getCount()).setMimeType(a.getMimeType()));
            }
            catch (ZipException zipException) {
                Log.warning((String)zipException.getMessage(), (Throwable)zipException);
            }
        }
    }

    void close() throws IOException {
        if (this.zos != null) {
            this.zos.close();
        }
    }

    private static String getFlightRecordingName(String reportIdentifier) {
        return reportIdentifier + ZIP_FILE_FILE_ENDING;
    }

    static String getReportPath(String reportIdentifier, String flightReportFolder) {
        return flightReportFolder + File.separator + ZipReportWriter.getFlightRecordingName(reportIdentifier);
    }

    void writeMetadata(MetadataModel metadata) throws IOException {
        ByteArrayOutputStream metadataDataOutput = new ByteArrayOutputStream();
        ObjectWriter objectWriter = new ObjectMapper().writerWithDefaultPrettyPrinter();
        objectWriter.writeValue((OutputStream)metadataDataOutput, (Object)metadata);
        this.zos.putNextEntry(new ZipEntry(METADATA_FILE_NAME));
        this.zos.write(metadataDataOutput.toByteArray());
    }
}

