/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.application.driver.conceptoperations;

import com.ur.polyscope.application.driver.conceptoperations.LoadMenuDriver;
import com.ur.polyscope.application.driver.conceptoperations.OpenFileDialogDriver;
import com.ur.polyscope.application.driver.conceptoperations.SaveMenuDriver;
import com.ur.polyscope.driver.api.BaseDriver;
import com.ur.polyscope.driver.api.MainScreen;
import com.ur.polyscope.driver.api.dialog.Dialog;
import com.ur.polyscope.driver.api.dialog.DialogDriverFactory;
import com.ur.polyscope.driver.api.dialog.DialogWithName;
import com.ur.polyscope.driver.api.header.HeaderMenuDriver;
import com.ur.util.Waiting;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

public class ApplicationPersistenceDriver
extends BaseDriver {
    private static final String CONFIRM_BUTTON = "confirm.confirmMessageDialog";
    private static final String ACTIVE_PROGRAM_HEADER = "activeProgramHeaderLabel.ActiveProgramAndInstallationDisplay";
    private static final String ACTIVE_INSTALLATION_HEADER = "activeInstallationHeaderLabel.ActiveProgramAndInstallationDisplay";
    private final HeaderMenuDriver headerMenuDriver;

    @Inject
    public ApplicationPersistenceDriver(MainScreen mainScreen, String driverShowingComponentName, HeaderMenuDriver headerMenuDriver) {
        super(mainScreen, driverShowingComponentName);
        this.headerMenuDriver = headerMenuDriver;
    }

    public void saveProgramHeader(String programName) {
        OpenFileDialogDriver saveDialog = ((SaveMenuDriver)this.headerMenuDriver.press(SaveMenuDriver.class)).saveProgram();
        saveDialog.pushButton("homeDirectory.URFileChooser");
        saveDialog.clearAndType(programName);
        saveDialog.saveAndOverwriteFile();
    }

    public void saveProgramNewDirectory(String programName, String folderName) {
        OpenFileDialogDriver saveDialog = ((SaveMenuDriver)this.headerMenuDriver.press(SaveMenuDriver.class)).saveProgram();
        saveDialog.pushButton("homeDirectory.URFileChooser");
        saveDialog.selectFile(folderName);
        saveDialog.clearAndType(programName);
        saveDialog.saveAndOverwriteFile();
    }

    public void saveInstallationHeader(String installationName) {
        OpenFileDialogDriver saveDialog = ((SaveMenuDriver)this.headerMenuDriver.press(SaveMenuDriver.class)).saveInstallation();
        saveDialog.pushButton("homeDirectory.URFileChooser");
        saveDialog.clearAndType(installationName);
        saveDialog.saveAndOverwriteFile();
    }

    public void copyPasteProgram(String programName, String folderName) {
        OpenFileDialogDriver loadDialog = ((LoadMenuDriver)this.headerMenuDriver.press(LoadMenuDriver.class)).loadProgram();
        loadDialog.pushButton("homeDirectory.URFileChooser");
        loadDialog.selectFile(programName);
        loadDialog.pushButton("copy.URFileChooser");
        loadDialog.selectFile(folderName);
        loadDialog.pushButton("paste.URFileChooser");
        loadDialog.cancelLoadProgram();
    }

    public void cutPasteProgram(String programName, String folderName) {
        OpenFileDialogDriver loadDialog = ((LoadMenuDriver)this.headerMenuDriver.press(LoadMenuDriver.class)).loadProgram();
        loadDialog.pushButton("homeDirectory.URFileChooser");
        loadDialog.selectFile(programName);
        loadDialog.pushButton("cut.URFileChooser");
        loadDialog.selectFile(folderName);
        loadDialog.pushButton("paste.URFileChooser");
        loadDialog.cancelLoadProgram();
    }

    public void loadProgramHeader(String programName) {
        OpenFileDialogDriver loadDialog = ((LoadMenuDriver)this.headerMenuDriver.press(LoadMenuDriver.class)).loadProgram();
        loadDialog.pushButton("homeDirectory.URFileChooser");
        loadDialog.selectFile(programName);
        loadDialog.openFile();
    }

    public void loadProgramNewDirectory(String programName, String folderName) {
        OpenFileDialogDriver loadDialog = ((LoadMenuDriver)this.headerMenuDriver.press(LoadMenuDriver.class)).loadProgram();
        loadDialog.pushButton("homeDirectory.URFileChooser");
        loadDialog.selectFile(folderName);
        loadDialog.selectFile(programName);
        loadDialog.openFile();
    }

    public boolean programLoaded(String programName) {
        return Waiting.until(() -> this.labelNamed(ACTIVE_PROGRAM_HEADER).getText().equals(programName), (int)5, (TimeUnit)TimeUnit.SECONDS);
    }

    public void loadInstallationHeader(String installationName) {
        OpenFileDialogDriver loadDialog = ((LoadMenuDriver)this.headerMenuDriver.press(LoadMenuDriver.class)).loadInstallation();
        Waiting.until(() -> this.isShowing("homeDirectory.URFileChooser"), (int)1, (TimeUnit)TimeUnit.SECONDS);
        loadDialog.pushButton("homeDirectory.URFileChooser");
        Waiting.until(() -> this.isShowing(installationName), (int)1, (TimeUnit)TimeUnit.SECONDS);
        loadDialog.selectFile(installationName);
        loadDialog.openFile();
        this.waitAndConfirmSafety();
        this.updateProgramInstallation();
    }

    public boolean installationLoaded(String installationName) {
        return Waiting.until(() -> this.labelNamed(ACTIVE_INSTALLATION_HEADER).getText().equals(installationName), (int)5, (TimeUnit)TimeUnit.SECONDS);
    }

    private void waitAndConfirmSafety() {
        if (this.isDialogShown((Dialog)DialogWithName.APPLY_SAFETY_CONFIGURATION)) {
            DialogDriverFactory.createDriver((Dialog)DialogWithName.APPLY_SAFETY_CONFIGURATION).pushButton(CONFIRM_BUTTON);
        }
    }

    private void updateProgramInstallation() {
        DialogWithName dialog = DialogWithName.SET_INSTALLATION_FOR_PROGRAM;
        boolean dialogShown = Waiting.until((Waiting.ItHappens)new DialogShowing(dialog), (int)5, (TimeUnit)TimeUnit.SECONDS);
        if (dialogShown) {
            DialogDriverFactory.createDriver((Dialog)dialog).pushButton(CONFIRM_BUTTON);
        }
    }

    public boolean isDialogShown(Dialog dialog) {
        return DialogDriverFactory.isDialogShown((Dialog)dialog);
    }

    private class DialogShowing
    implements Waiting.ItHappens {
        private final DialogWithName dialog;

        public DialogShowing(DialogWithName dialog) {
            this.dialog = dialog;
        }

        public boolean itHappened() {
            return DialogDriverFactory.isDialogShown((Dialog)this.dialog);
        }
    }
}

