/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.application.driver.filemanager;

import com.ur.polyscope.driver.api.BaseDriver;
import com.ur.polyscope.driver.api.MainScreen;
import com.ur.polyscope.driver.api.NotEnabled;
import com.ur.polyscope.driver.api.dialog.DialogRegistry;
import com.ur.swing.text.driver.TextPickerOperator;
import com.ur.util.Waiting;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.operators.JComponentOperator;
import org.netbeans.jemmy.operators.JListOperator;
import org.netbeans.jemmy.operators.JTextComponentOperator;
import org.netbeans.jemmy.operators.JTextFieldOperator;

public class OpenFileDialogDriver
extends BaseDriver {
    public static final String FILE_NAME_INPUT_FIELD = "FileNameField.URFileChooser";
    public static final String FILE_NAME_LABEL = "FileNameLabel.URFileChooser";
    public static final String OPEN_FILE = "openFileButton.URFileChooser";
    public static final String SAVE_FILE = "saveFileButton.URFileChooser";
    public static final String FILE_LIST = "fileList.URFileChooser";
    public static final String BACK_ONE_DIRECTORY = "backOneDirectory.URFileChooser";
    public static final String HOME_DIRECTORY = "homeDirectory.URFileChooser";
    public static final String CANCEL = "cancel.URFileChooser";
    public static final String HOME = "jump.to.home.directory";
    public static final String BACKUP_TO_USB = "backUpToUsb.URFileChooser";
    public static final String BREADCRUMB = "breadcrumb.URFileChooser";
    public static final String BREADCRUMB_RIGHT = "breadcrumb.right.URFileChooser";
    public static final String BREADCRUMB_LEFT = "breadcrumb.left.URFileChooser";
    public static final String BREADCRUMB_FILEBUTTON_PREFIX = "breadcrumb.prefix.URFileChooser";
    public static final String DELETE = "delete.URFileChooser";
    public static final String RENAME = "rename.URFileChooser";
    public static final String COPY = "copy.URFileChooser";
    public static final String PASTE = "paste.URFileChooser";
    public static final String NEW_DIRECTORY = "new.directory.URFileChooser";
    public static final String CUT = "cut.URFileChooser";
    public static final String CONFIRM_BUTTON = "confirm.confirmMessageDialog";
    public static final String CANCEL_BUTTON = "cancel.confirmMessageDialog";
    public static final String NOT_NOW = "notNow.MessageDialogPanel";
    public static final String ERROR_OK = "rightArrowKey.MessageDialogPanel";
    private final DialogRegistry dialogRegistry;

    @Inject
    public OpenFileDialogDriver(MainScreen mainScreen, DialogRegistry dialogRegistry) {
        super(mainScreen, CANCEL);
        this.dialogRegistry = dialogRegistry;
        Waiting.until((Waiting.ItHappens)new Waiting.ItHappens(){

            public boolean itHappened() {
                return OpenFileDialogDriver.this.isShowing();
            }
        }, (int)5, (TimeUnit)TimeUnit.SECONDS);
    }

    public void goUpOneDirectory() {
        super.push(this.buttonNamed(BACK_ONE_DIRECTORY));
    }

    public TextPickerOperator clearAndType(String name) {
        TextPickerOperator textPickerOperator = this.textPicker();
        textPickerOperator.setTextInField("");
        textPickerOperator.typeFullText(name);
        return textPickerOperator;
    }

    public TextPickerOperator textPicker() {
        JTextFieldOperator jTextFieldOperator = this.textFieldNamed(FILE_NAME_INPUT_FIELD);
        return this.clickForTextPicker((JTextComponentOperator)this.in(jTextFieldOperator));
    }

    private TextPickerOperator clickForTextPicker(JTextComponentOperator componentOperator) {
        if (!Waiting.until((Waiting.ItHappens)this.isEnabled((JComponentOperator)componentOperator), (int)1, (TimeUnit)TimeUnit.SECONDS)) {
            throw new NotEnabled("TextComponent named '" + componentOperator.getName() + "' was not enabled when trying to open text picker");
        }
        return new TextPickerOperator(componentOperator);
    }

    public void selectFile(String programToLoad) {
        if (!this.selectItem(programToLoad, this.listNamed(FILE_LIST))) {
            throw new JemmyException("Unable to find element '" + programToLoad + "'");
        }
    }

    private boolean selectItem(String programToLoad, JListOperator listNamed) {
        return Waiting.until(() -> {
            Waiting.pause((long)150L, (TimeUnit)TimeUnit.MILLISECONDS);
            try {
                listNamed.clickOnItem(programToLoad, 1);
                Waiting.pause((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }, (int)10, (TimeUnit)TimeUnit.SECONDS);
    }

    public void openFile() {
        this.push(this.buttonNamed(OPEN_FILE));
        this.validateFileManagerIsClosed();
    }

    public void saveFile() {
        this.push(this.buttonNamed(SAVE_FILE));
        this.validateFileManagerIsClosed();
    }

    public void cancelLoadProgram() {
        this.push(this.buttonNamed(CANCEL));
        this.validateFileManagerIsClosed();
    }

    public boolean isNotShowing() {
        return this.isNotShowing(CANCEL);
    }

    private void validateFileManagerIsClosed() {
        if (!Waiting.until(this::isNotShowing, (int)10, (TimeUnit)TimeUnit.SECONDS)) {
            throw new IllegalStateException("Still showing open file dialog after file was opened");
        }
    }

    public void pushButton(String name) {
        this.push(this.buttonNamed(name));
    }

    public void renameFile() {
        this.push(this.buttonNamed(RENAME));
    }

    public void deleteFile() {
        this.push(this.buttonNamed(DELETE));
    }

    public boolean isNotShowing(String componentWithName) {
        return super.isNotShowing(componentWithName);
    }

    public void pushButtonInDialog(String buttonName, String dialogTitle) {
        this.dialogRegistry.inDialog(dialogTitle).pushButton(buttonName);
    }
}

