/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.application.driver.freedrive;

import com.ur.polyscope.driver.api.BaseDriver;
import com.ur.polyscope.driver.api.MainScreen;
import com.ur.polyscope.freedrive.panel.FreedrivePanel;
import java.awt.Component;
import java.awt.Window;
import java.util.Objects;
import java.util.function.Function;
import javax.inject.Inject;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JToggleButton;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.operators.JComponentOperator;
import org.netbeans.jemmy.operators.JDialogOperator;
import org.netbeans.jemmy.operators.JToggleButtonOperator;

public class FreedriveDriver
extends BaseDriver {
    private final FreedrivePanel freedrivePanel;
    private static final String DIALOG_NAME = "freedriveDialog";

    @Inject
    FreedriveDriver(MainScreen mainScreen, FreedrivePanel freedrivePanel) {
        super(mainScreen, "FreedrivePanel");
        this.freedrivePanel = freedrivePanel;
    }

    public void showFreedrivePanel() {
        this.freedrivePanel.show();
    }

    public void closeFreedrivePanel() {
        this.freedrivePanel.hide(true);
    }

    public void showFreedrivePanelPinned() {
        this.freedrivePanel.showPinned();
    }

    public void hideFreedrivePanel(boolean force) {
        this.freedrivePanel.hide(force);
    }

    public boolean isToggleSelected(String name) {
        JToggleButtonOperator toggle = this.findComponent(Objects.requireNonNull(this.findDialog()), JToggleButton.class, name, JToggleButtonOperator::new);
        return toggle != null && toggle.isSelected();
    }

    public void clickOnTogglePlane(String name) {
        JToggleButtonOperator toggle = this.findComponent(Objects.requireNonNull(this.findDialog()), JToggleButton.class, name, JToggleButtonOperator::new);
        if (toggle != null) {
            toggle.clickMouse();
        }
    }

    private <T extends JComponent, K extends JComponentOperator> K findComponent(JDialogOperator parentOperator, final Class<T> type, final String name, Function<T, K> fn) {
        Component subComponent = parentOperator.findSubComponent(new ComponentChooser(){

            public boolean checkComponent(Component component) {
                if (!type.isAssignableFrom(component.getClass())) {
                    return false;
                }
                JComponent instance = (JComponent)component;
                return name.equals(instance.getName());
            }

            public String getDescription() {
                return null;
            }
        });
        return (K)(subComponent != null ? (JComponentOperator)fn.apply((JComponent)subComponent) : null);
    }

    private JDialogOperator findDialog() {
        for (Window window : Window.getWindows()) {
            JDialog jd;
            if (!(window instanceof JDialog) || !(jd = (JDialog)window).getTitle().equals(DIALOG_NAME)) continue;
            return new JDialogOperator(jd);
        }
        return null;
    }

    public boolean isDialogVisible() {
        JDialogOperator dialog = this.findDialog();
        if (dialog != null) {
            return dialog.isVisible();
        }
        return false;
    }

    public void clickOutsidePanel() {
        this.longPush(this.buttonNamed("installationScreen.HeaderMenu"), 1);
    }
}

