/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.application.driver.geomfeature;

import com.ur.polyscope.application.driver.conceptoperations.LoadMenuDriver;
import com.ur.polyscope.application.driver.conceptoperations.OpenFileDialogDriver;
import com.ur.polyscope.driver.api.BaseDriver;
import com.ur.polyscope.driver.api.MainScreen;
import com.ur.polyscope.driver.api.dialog.Dialog;
import com.ur.polyscope.driver.api.dialog.DialogDriverFactory;
import com.ur.polyscope.driver.api.dialog.DialogWithName;
import com.ur.util.Waiting;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

public class URCapFeaturesScreenDriver
extends BaseDriver {
    private static final String ADD_POINT_FEATURE = "addPointFeature.G5FeaturesTab";
    private static final String URCAP_FEATURES_TREE = "urcap.featuresTree.G5FeaturesTab";
    private static final String RENAME_SELECTED_FEATURE = "GeomCardRenameFeatureButton";
    private static final String SET_THIS_POINT = "changeThisFeatureButton.WaypointCard";
    private static final String CONFIRM_BUTTON = "confirm.confirmMessageDialog";
    private static final String OK_BUTTON = "rightArrowKey.MessageDialogPanel";
    private static final String MISSING_URCAP_TITLE = "Missing URCap";
    private static final Dialog MISSING_URCAP = DialogWithName.RUNTIME_EXCEPTION;
    private final LoadMenuDriver loadMenuDriver;

    @Inject
    public URCapFeaturesScreenDriver(MainScreen mainScreen, LoadMenuDriver loadMenuDriver) {
        super(mainScreen, ADD_POINT_FEATURE);
        this.loadMenuDriver = loadMenuDriver;
    }

    public int urcapFeatureCount() {
        return this.treeNamed(URCAP_FEATURES_TREE).getRowCount();
    }

    public boolean isNotShowingURCapFeatures() {
        return this.isNotShowing(URCAP_FEATURES_TREE);
    }

    public void selectURCapFeature(String nameOfFeature) {
        this.push(this.itemMatching(nameOfFeature, this.treeNamed(URCAP_FEATURES_TREE)));
    }

    public boolean renameUnavailable() {
        return this.isNotShowing(RENAME_SELECTED_FEATURE);
    }

    public boolean setPointUnavailable() {
        return this.isNotShowing(SET_THIS_POINT);
    }

    public void loadInstallation(String fileName) {
        this.loadMenuDriver.press();
        Waiting.until((Waiting.ItHappens)new Waiting.ItHappens(){

            public boolean itHappened() {
                return URCapFeaturesScreenDriver.this.isShowing("fileManager.open.FileManagerButtonFactory.popup");
            }
        }, (int)2, (TimeUnit)TimeUnit.SECONDS);
        final OpenFileDialogDriver fileDialog = this.loadMenuDriver.loadInstallation();
        if (DialogDriverFactory.isDialogShown((Dialog)DialogWithName.UNSAVED_INSTALLATION_CHANGES)) {
            DialogDriverFactory.createDriver((Dialog)DialogWithName.UNSAVED_INSTALLATION_CHANGES).pushButton(CONFIRM_BUTTON);
        }
        Waiting.until((Waiting.ItHappens)new Waiting.ItHappens(){

            public boolean itHappened() {
                return !fileDialog.isNotShowing();
            }
        }, (int)3, (TimeUnit)TimeUnit.SECONDS);
        fileDialog.selectFile(fileName);
        fileDialog.openFile();
        if (DialogDriverFactory.isDialogShown((Dialog)DialogWithName.APPLY_SAFETY_CONFIGURATION)) {
            DialogDriverFactory.createDriver((Dialog)DialogWithName.APPLY_SAFETY_CONFIGURATION).pushButton(CONFIRM_BUTTON);
        }
        if (DialogDriverFactory.isDialogShown((Dialog)DialogWithName.SET_INSTALLATION_FOR_PROGRAM)) {
            DialogDriverFactory.createDriver((Dialog)DialogWithName.SET_INSTALLATION_FOR_PROGRAM).pushButton(CONFIRM_BUTTON);
        }
        if (DialogDriverFactory.isDialogShown((Dialog)MISSING_URCAP)) {
            DialogDriverFactory.createDriver((Dialog)MISSING_URCAP).pushButton(OK_BUTTON);
        }
        Waiting.until((Waiting.ItHappens)new Waiting.ItHappens(){

            public boolean itHappened() {
                return !DialogDriverFactory.isDialogShown((Dialog)DialogWithName.APPLY_SAFETY_CONFIGURATION);
            }
        }, (int)10, (TimeUnit)TimeUnit.SECONDS);
    }
}

