/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.application.driver.initializerobot;

import com.ur.lang.EqualsUtil;
import com.ur.log.logentry.robotmessage.RobotModes;
import com.ur.polyscope.driver.api.BaseDriver;
import com.ur.polyscope.driver.api.MainScreen;
import com.ur.swing.JemmyUtils;
import com.ur.util.Waiting;
import com.ur.view.constants.dev.RobotMode;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import org.netbeans.jemmy.operators.JComponentOperator;

public class InitializeRobotScreenDriver
extends BaseDriver {
    private static final String OK_BUTTON = "okOrExitButton.RobotInitializationPanel";
    private static final String ON_BUTTON = "onButton.RobotInitializationPanel";
    private static final String OFF_BUTTON = "offButton.RobotInitializationPanel";
    private static final String STATUS_LABEL = "status.RobotInitializationPanel";
    private static final String OK_INDICATOR = "OK.RobotInitializationPanel";
    private static final String INIT_ROBOT_SCREEN = "initRobotScreen.HeaderMenu";
    private static final String GREEN_LABEL_NAME = "VisualInitializationPanel.greenLabel";
    private static final String INITIALIZATION_FLOW_NAME = "VisualInitializationPanel.initializeFlow";
    private static final String SAFE_BRAKE_POWER_OFF = "brakeFailureOffButton.RobotInitializationPanel";

    @Inject
    public InitializeRobotScreenDriver(MainScreen mainScreen, String driverShowingComponentName) {
        super(mainScreen, driverShowingComponentName);
    }

    public InitializeRobotScreenDriver(MainScreen polyScopeUI) {
        super(polyScopeUI, ON_BUTTON);
        this.showInitializeRobotScreen();
    }

    private void showInitializeRobotScreen() {
        this.push(this.buttonNamed(INIT_ROBOT_SCREEN));
        JemmyUtils.waitForIdle((int)3, (TimeUnit)TimeUnit.SECONDS);
        InitializeRobotScreenDriver.assertTrue("InitializeRobotScreen was not shown after header menu button pressed", this.isShowing());
    }

    public void waitForRobotPoweredOff() {
        InitializeRobotScreenDriver.assertTrue("Could not connect to controller socket!", Waiting.until((Waiting.ItHappens)new ControllerConnected(), (int)5, (TimeUnit)TimeUnit.SECONDS));
        this.push(this.buttonNamed(OFF_BUTTON));
        InitializeRobotScreenDriver.assertTrue("Did not get into power off state!", Waiting.until((Waiting.ItHappens)new PoweredOff(), (int)10000, (int)300, (TimeUnit)TimeUnit.MILLISECONDS));
    }

    public void safeBrakePowerOffIsShown() {
        this.buttonNamed(SAFE_BRAKE_POWER_OFF);
    }

    public void initializeRobotAndExit() {
        this.initializeRobot();
        this.exit();
    }

    public void initializeRobot() {
        this.printLine("Connecting to the controller socket");
        InitializeRobotScreenDriver.assertTrue("Could not connect to controller socket!", Waiting.until((Waiting.ItHappens)new ControllerConnected(), (int)5, (TimeUnit)TimeUnit.SECONDS));
        this.printLine("Initializing the robot...");
        InitializeRobotScreenDriver.assertTrue("Could not start the controller!", Waiting.until((Waiting.ItHappens)new NormalModeReached(), (int)10000, (int)300, (TimeUnit)TimeUnit.MILLISECONDS));
        this.printLine("Initializing successful.");
    }

    public void exit() {
        this.push(this.buttonNamed(OK_BUTTON));
    }

    public void initialize() {
        this.showInitializeRobotScreen();
        this.initializeRobot();
        this.exit();
        InitializeRobotScreenDriver.waitForIdle(2);
    }

    private static void assertTrue(String message, boolean value) {
        if (!value) {
            throw new RuntimeException(message);
        }
    }

    private static void waitForIdle(int i) {
        try {
            Thread.yield();
            Thread.sleep((long)i * 1000L);
            JemmyUtils.waitForIdle((int)i, (TimeUnit)TimeUnit.SECONDS);
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private class ControllerConnected
    implements Waiting.ItHappens {
        private ControllerConnected() {
        }

        public boolean itHappened() {
            try {
                JComponentOperator component = InitializeRobotScreenDriver.this.componentNamed(InitializeRobotScreenDriver.GREEN_LABEL_NAME);
                return component.isShowing();
            }
            catch (Exception e) {
                try {
                    JComponentOperator component = InitializeRobotScreenDriver.this.componentNamed(InitializeRobotScreenDriver.INITIALIZATION_FLOW_NAME);
                    return component.isShowing();
                }
                catch (Exception e1) {
                    return false;
                }
            }
        }
    }

    private class PoweredOff
    implements Waiting.ItHappens {
        private PoweredOff() {
        }

        public boolean itHappened() {
            String poweredOffText = RobotModes.getString((RobotMode)RobotMode.POWER_OFF);
            String labelText = InitializeRobotScreenDriver.this.labelNamed(InitializeRobotScreenDriver.STATUS_LABEL).getText();
            return EqualsUtil.equals((Object)labelText, (Object)poweredOffText);
        }
    }

    private class NormalModeReached
    implements Waiting.ItHappens {
        private NormalModeReached() {
        }

        public boolean itHappened() {
            if (!InitializeRobotScreenDriver.this.quickIsShowing(InitializeRobotScreenDriver.OK_INDICATOR)) {
                InitializeRobotScreenDriver.this.buttonNamed(InitializeRobotScreenDriver.ON_BUTTON).doClick();
                return false;
            }
            return true;
        }
    }
}

