/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.application.driver.installation;

import com.ur.polyscope.driver.api.BaseDriver;
import com.ur.polyscope.driver.api.MainScreen;
import com.ur.swing.number.driver.NumberKeyPadOperator;
import com.ur.util.Waiting;
import java.util.concurrent.TimeUnit;
import org.netbeans.jemmy.operators.JComboBoxOperator;
import org.netbeans.jemmy.operators.JTextFieldOperator;

public class URCapInstallationNodeDriver
extends BaseDriver {
    public static final String INSTALLATION_NODE_VIEW = ".InstallationNodeView";

    public static URCapInstallationNodeDriver get() {
        return new URCapInstallationNodeDriver(new MainScreen(null){});
    }

    protected URCapInstallationNodeDriver(MainScreen mainScreen) {
        super(mainScreen, "installationNode-gripper-driver");
    }

    public void uncheck(String withName) {
        String id = withName + INSTALLATION_NODE_VIEW;
        this.waitFor(id, true);
        this.checkBoxNamed(id).pushNoBlock();
        this.waitFor(id, false);
    }

    private void waitFor(String id, boolean value) {
        if (!Waiting.until(() -> {
            if (this.checkBoxNamed(id).isSelected() != value) {
                this.checkBoxNamed(id).pushNoBlock();
                return false;
            }
            return true;
        }, (int)30, (int)1, (TimeUnit)TimeUnit.SECONDS)) {
            throw new AssertionError((Object)("Failed to set checkbox " + (value ? "checked" : "Unchecked")));
        }
    }

    public void enterNumericValue(String withName, String value) {
        String id = withName + INSTALLATION_NODE_VIEW;
        new NumberKeyPadOperator(this.textFieldNamed(id)).punchInKeypad(value);
        this.waitFor(this.textFieldNamed(id), value);
    }

    private boolean waitFor(JTextFieldOperator element, String value) {
        return Waiting.until(() -> element.getText().equals(value), (int)1, (TimeUnit)TimeUnit.MINUTES);
    }

    public void select(String withName, int index) {
        String id = withName + INSTALLATION_NODE_VIEW;
        JComboBoxOperator comboBoxOperator = this.comboBoxNamed(id);
        comboBoxOperator.selectItem(index);
    }
}

