/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.application.driver.io;

import com.ur.polyscope.driver.api.BaseDriver;
import com.ur.polyscope.driver.api.MainScreen;
import com.ur.polyscope.driver.api.ScreenComponentDriver;
import com.ur.polyscope.driver.api.dialog.DialogRegistry;
import com.ur.polyscope.driver.api.installation.InstallationScreenDriver;
import com.ur.swing.JemmyUtils;
import com.ur.util.Waiting;
import com.ur.view.constants.dev.ToolDigitalOutputMode;
import com.ur.view.constants.dev.ToolOutputMode;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.netbeans.jemmy.TimeoutExpiredException;
import org.netbeans.jemmy.operators.AbstractButtonOperator;
import org.netbeans.jemmy.operators.JComboBoxOperator;
import org.netbeans.jemmy.operators.JComponentOperator;
import org.netbeans.jemmy.operators.JPopupMenuOperator;

public class ToolIOScreenDriver
extends BaseDriver
implements ScreenComponentDriver {
    private static final String PROGRAM_SCREEN = "programScreen.HeaderMenu";
    private static final String FILE_MANAGER_OPEN = "fileManager.open.FileManagerButtonFactory";
    private static final String LOAD_PROGRAM = "loadProgram.ProgramFilePersistence";
    private static final String SAVE_INSTALLATION = "saveInstallation.InstallationFilePersistence";
    private static final String SELECT_COMMUNICATION_INTERFACE = "enableButton.ToolIOSwingView";
    private static final String YES_BUTTON = "confirm.confirmMessageDialog";
    private static final String NO_BUTTON = "cancel.confirmMessageDialog";
    private static final String GENERAL_TAB = "generalTab.G5InstallationTab";
    private static final String CONTROL_COMBOBOX = "controlCombobox.ToolIOSwingView";
    private static final String SHOW_TOOL_ACTION_TOOL_IOSWING_VIEW = "showToolAction.ToolIOSwingView";
    private static final String SELECT_ANALOG_INPUTS = "analogInputs.ToolIOSwingView";
    private static final String TOOL_MODE_PANEL_TOOL_IOSWING_VIEW = "ToolModePanel.ToolIOSwingView";
    private static final String TOOL_COMM_INFO_PANEL_TOOL_IOSWING_VIEW = "ToolCommInfoPanel.ToolIOSwingView";
    private static final String FILE_MANAGER_SAVE = "fileManager.save.FileManagerButtonFactory";
    private static final String DIGITAL_0_MODE = "digital0mode.ToolIOSwingView";
    private static final String DIGITAL_1_MODE = "digital1mode.ToolIOSwingView";
    private static final String STANDARD_OUTPUT_MODE = "outputmode.ToolIOSwingView";
    private static final String POWER_MODE = "powermode.ToolIOSwingView";
    public static final String PROGRAM_HAS_NOT_BEEN_SAVED_DIALOG_TITLE = "The program has not been saved. Do you want to save your changes?";
    public static final String SET_INSTALLATION_FOR_PROGRAM_DIALOG_TITLE = "Update Program Installation?";
    public static final String CONFIRM_OVERWRITE_DIALOG_TITLE = "Overwrite Existing File?";
    private static final int TIMEOUT = 10;
    private final DialogRegistry dialogRegistry;
    private final InstallationScreenDriver installationScreenDriver;

    @Inject
    ToolIOScreenDriver(MainScreen mainScreen, DialogRegistry dialogRegistry, InstallationScreenDriver installationScreenDriver) {
        super(mainScreen, SELECT_COMMUNICATION_INTERFACE);
        this.dialogRegistry = dialogRegistry;
        this.installationScreenDriver = installationScreenDriver;
    }

    private void goTo(String screen) {
        this.push(this.buttonNamed(screen));
        JemmyUtils.waitForIdle((int)3, (TimeUnit)TimeUnit.SECONDS);
    }

    public void goToInstallationScreen() {
        this.installationScreenDriver.select();
    }

    public void goToProgramScreen() {
        this.goTo(PROGRAM_SCREEN);
    }

    public void goToGeneralTab() {
        this.goTo(GENERAL_TAB);
    }

    public void enableToolComm() {
        this.push(this.buttonNamed(SELECT_COMMUNICATION_INTERFACE));
    }

    public void enableAnalogInputs() {
        this.push(this.buttonNamed(SELECT_ANALOG_INPUTS));
    }

    public void goToToolIOScreen() {
        this.goTo(SHOW_TOOL_ACTION_TOOL_IOSWING_VIEW);
    }

    public JComboBoxOperator getControlCombobox() {
        return this.comboBoxNamed(CONTROL_COMBOBOX);
    }

    public boolean isSubpanelsEnabled() {
        JComponentOperator toolModePanel = this.componentNamed(TOOL_MODE_PANEL_TOOL_IOSWING_VIEW);
        JComponentOperator toolCommInfoPanel = this.componentNamed(TOOL_COMM_INFO_PANEL_TOOL_IOSWING_VIEW);
        return toolModePanel.isEnabled() && toolCommInfoPanel.isEnabled();
    }

    private JPopupMenuOperator openMenuDropdown(String menu) {
        if (this.isNotShowing(menu)) {
            throw new IllegalStateException(menu + " header menu button is not shown");
        }
        JPopupMenuOperator popupMenuOperator = this.pushForPopup(menu);
        if (popupMenuOperator == null) {
            popupMenuOperator = this.pushForPopup(menu);
        }
        if (popupMenuOperator == null) {
            throw new IllegalStateException(menu + " header popup menu was not open");
        }
        return popupMenuOperator;
    }

    private JPopupMenuOperator pushForPopup(String menu) {
        this.push(this.buttonNamed(menu));
        try {
            return this.popupMenuNamed(menu + ".popup");
        }
        catch (TimeoutExpiredException ignored) {
            return null;
        }
    }

    public void setToolOutputMode(ToolOutputMode desiredMode) {
        this.push((AbstractButtonOperator)this.radioButtonNamed(desiredMode == ToolOutputMode.POWER ? POWER_MODE : STANDARD_OUTPUT_MODE));
    }

    public void setDigital0(ToolDigitalOutputMode item) {
        this.comboBoxNamed(DIGITAL_0_MODE).setSelectedItem((Object)item);
        this.checkDigital0(item);
    }

    public void setDigital1(ToolDigitalOutputMode item) {
        this.comboBoxNamed(DIGITAL_1_MODE).setSelectedItem((Object)item);
        this.checkDigital1(item);
    }

    public boolean checkDigital0(final ToolDigitalOutputMode expected) {
        return Waiting.until((Waiting.ItHappens)new Waiting.ItHappens(){

            public boolean itHappened() {
                return expected == ToolIOScreenDriver.this.comboBoxNamed(ToolIOScreenDriver.DIGITAL_0_MODE).getSelectedItem();
            }
        }, (int)10, (TimeUnit)TimeUnit.SECONDS);
    }

    public boolean checkDigital1(final ToolDigitalOutputMode expected) {
        return Waiting.until((Waiting.ItHappens)new Waiting.ItHappens(){

            public boolean itHappened() {
                return expected == ToolIOScreenDriver.this.comboBoxNamed(ToolIOScreenDriver.DIGITAL_1_MODE).getSelectedItem();
            }
        }, (int)10, (TimeUnit)TimeUnit.SECONDS);
    }

    public void openLoadProgramDialog() {
        JPopupMenuOperator openMenu = this.openMenuDropdown(FILE_MANAGER_OPEN);
        this.pushPopupMenuItem(openMenu, LOAD_PROGRAM);
    }

    public void saveInstallationAs() {
        JPopupMenuOperator openMenu = this.openMenuDropdown(FILE_MANAGER_SAVE);
        this.pushPopupMenuItem(openMenu, SAVE_INSTALLATION);
    }

    public boolean isDialogShown(String dialogTitle) {
        return this.dialogRegistry.isDialogShown(dialogTitle);
    }

    public void pushDiscardChangesOnDialog(String dialogTitle) {
        this.dialogRegistry.inDialog(dialogTitle).pushButton(NO_BUTTON);
    }

    public void pushConfirmChangesOnDialog(String dialogTitle) {
        this.dialogRegistry.inDialog(dialogTitle).pushButton(YES_BUTTON);
    }

    public boolean checkControllerRecievedToolOutputPowerMode() {
        return Waiting.until((Waiting.ItHappens)new Waiting.ItHappens(){

            public boolean itHappened() {
                return ToolIOScreenDriver.this.radioButtonNamed(ToolIOScreenDriver.POWER_MODE).isSelected();
            }
        }, (int)10, (TimeUnit)TimeUnit.SECONDS);
    }

    public void select() {
        this.goTo(SELECT_COMMUNICATION_INTERFACE);
    }
}

