/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.application.driver.logging;

import com.ur.polyscope.driver.api.BaseDriver;
import com.ur.polyscope.driver.api.MainScreen;
import com.ur.polyscope.driver.api.ScreenComponentDriver;
import com.ur.swing.JemmyUtils;
import com.ur.util.Waiting;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.swing.ButtonModel;
import javax.swing.JLabel;
import javax.swing.JToggleButton;
import org.netbeans.jemmy.operators.JComponentOperator;
import org.netbeans.jemmy.operators.JListOperator;

public class LogTabDriver
extends BaseDriver
implements ScreenComponentDriver {
    public static final String LOG_SCREEN = "logScreen.HeaderMenu";
    public static final String LOG_ENTRIES = "logEntries.logTab";
    public static final String INFORMATION_LOG_SELECTOR = "informationSelector.logEntries.logTab";
    public static final String WARNING_LOG_SELECTOR = "warningSelector.logEntries.logTab";
    public static final String ERROR_LOG_SELECTOR = "errorSelector.logEntries.logTab";
    public static final String ATTACHMENT_LOG_SELECTOR = "attachmentSelector.logEntries.logTab";
    public static final String CLEAR_LOG = "clearLog.logEntires.logTab";
    public static final String EXPORT_BUTTON = "exportButton.logEntries.logTab";
    public static final String DETAIL_EXPLANATION_LOG = "detail.explanation.logTab";

    @Inject
    LogTabDriver(MainScreen mainScreen) {
        super(mainScreen, LOG_ENTRIES);
    }

    public void select() {
        this.push(this.buttonNamed(LOG_SCREEN));
        JemmyUtils.waitForIdle((int)3, (TimeUnit)TimeUnit.SECONDS);
    }

    public boolean isExportAttachmentButtonEnabled() {
        return this.buttonNamed(EXPORT_BUTTON).isEnabled();
    }

    public boolean exportAttachmentCompleted() {
        return Waiting.until((Waiting.ItHappens)new Waiting.ItHappens(){

            public boolean itHappened() {
                return LogTabDriver.this.isExportAttachmentButtonEnabled();
            }
        }, (int)1, (TimeUnit)TimeUnit.SECONDS);
    }

    public boolean exportAttachmentWorking() {
        return Waiting.until((Waiting.ItHappens)new Waiting.ItHappens(){

            public boolean itHappened() {
                return !LogTabDriver.this.isExportAttachmentButtonEnabled();
            }
        }, (int)10, (int)1, (TimeUnit)TimeUnit.SECONDS);
    }

    public void enableInformationFilter() {
        JToggleButton button = (JToggleButton)this.buttonNamed(INFORMATION_LOG_SELECTOR).getSource();
        ButtonModel model = button.getModel();
        if (model.isSelected()) {
            this.push(this.buttonNamed(INFORMATION_LOG_SELECTOR));
        }
    }

    public boolean isLogListEmpty() {
        JListOperator listOperator = this.listNamed(LOG_ENTRIES);
        return listOperator.getLastVisibleIndex() == -1;
    }

    public boolean isLogLogEntryPresent(String log) {
        JListOperator listOperator = this.listNamed(LOG_ENTRIES);
        return listOperator.findItemIndex(log) != -1;
    }

    public void selectLogEntry(String log) {
        JListOperator listOperator = this.listNamed(LOG_ENTRIES);
        listOperator.selectItem(log);
    }

    public String getExplanation() {
        if (this.isNotShowing(DETAIL_EXPLANATION_LOG)) {
            return null;
        }
        JComponentOperator jComponentOperator = this.componentNamed(DETAIL_EXPLANATION_LOG);
        if (jComponentOperator != null && jComponentOperator.getSource() instanceof JLabel) {
            return ((JLabel)jComponentOperator.getSource()).getText();
        }
        return null;
    }

    public void enableWarningFilter() {
        JToggleButton button = (JToggleButton)this.buttonNamed(WARNING_LOG_SELECTOR).getSource();
        ButtonModel model = button.getModel();
        if (model.isSelected()) {
            this.push(this.buttonNamed(WARNING_LOG_SELECTOR));
        }
    }
}

