/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.application.driver.logging;

import com.ur.polyscope.application.driver.filemanager.OpenFileDialogDriver;
import com.ur.polyscope.driver.api.BaseDriver;
import com.ur.polyscope.driver.api.MainScreen;
import com.ur.polyscope.driver.api.dialog.DialogDriver;
import com.ur.polyscope.driver.api.dialog.DialogRegistry;
import com.ur.swing.JemmyUtils;
import com.ur.util.Waiting;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.netbeans.jemmy.operators.JTextFieldOperator;

public class MyURDriver
extends BaseDriver {
    private static final String MYUR_BUTTON = "myURButton.logTab";
    private static final String MY_UR_FILE_CONTENT = "Support File";
    private static final String CONFIRM_CONFIRM_MESSAGE_DIALOG = "confirm.confirmMessageDialog";
    private static final String CANCEL_CONFIRM_MESSAGE_DIALOG = "cancel.confirmMessageDialog";
    public static final String OK_BUTTON = "rightArrowKey.MessageDialogPanel";
    private final DialogRegistry dialogRegistry;
    private final OpenFileDialogDriver openFileDialogDriver;

    @Inject
    public MyURDriver(MainScreen mainScreen, DialogRegistry dialogRegistry, OpenFileDialogDriver openFileDialogDriver) {
        super(mainScreen, MYUR_BUTTON);
        this.dialogRegistry = dialogRegistry;
        this.openFileDialogDriver = openFileDialogDriver;
    }

    public DialogDriver pressMyURButton() {
        this.buttonNamed(MYUR_BUTTON).push();
        return this.dialogRegistry.inDialog(MY_UR_FILE_CONTENT);
    }

    public OpenFileDialogDriver acceptConsentDialog() {
        DialogDriver dialogDriver = new DialogDriver(JemmyUtils.getDialogByTitle((String)MY_UR_FILE_CONTENT));
        dialogDriver.pushButton(CONFIRM_CONFIRM_MESSAGE_DIALOG);
        Waiting.until((Waiting.ItHappens)new Waiting.ItHappens(){

            public boolean itHappened() {
                return !MyURDriver.this.openFileDialogDriver.isNotShowing();
            }
        }, (int)5, (TimeUnit)TimeUnit.SECONDS);
        return this.openFileDialogDriver;
    }

    public void cancelConsentDialog() {
        DialogDriver dialogDriver = new DialogDriver(JemmyUtils.getDialogByTitle((String)MY_UR_FILE_CONTENT));
        dialogDriver.pushButton(CANCEL_CONFIRM_MESSAGE_DIALOG);
    }

    public String acceptCurrentFileName() {
        JTextFieldOperator jTextFieldOperator = this.textFieldNamed("FileNameField.URFileChooser");
        String fileName = jTextFieldOperator.getText();
        this.openFileDialogDriver.saveFile();
        return fileName;
    }

    public void acceptWithFileName(String filename) {
        this.openFileDialogDriver.clearAndType(filename).clickOkToClose();
        this.openFileDialogDriver.saveFile();
    }

    public void acceptSaveResultDialog() {
        DialogDriver dialogDriver = new DialogDriver(JemmyUtils.getDialogByTitle((String)MY_UR_FILE_CONTENT));
        dialogDriver.pushButton(OK_BUTTON);
        Waiting.until((Waiting.ItHappens)new Waiting.ItHappens(){

            public boolean itHappened() {
                return !MyURDriver.this.openFileDialogDriver.isNotShowing();
            }
        }, (int)5, (TimeUnit)TimeUnit.SECONDS);
    }
}

