/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.application.driver.move;

import com.ur.polyscope.application.driver.program.PlayPauseStepStopDriver;
import com.ur.polyscope.driver.api.BaseDriver;
import com.ur.polyscope.driver.api.MainScreen;
import com.ur.polyscope.driver.api.NotEnabled;
import com.ur.swing.JemmyUtils;
import com.ur.util.Waiting;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

public class AutoMoveScreenDriver
extends BaseDriver {
    public static final String AUTO_MOVE_BUTTON = "autoMoveButton.AutoMoveTab";
    public static final String MANUAL_MOVE_BUTTON = "manualMoveButton.AutoMoveTab";
    public static final String CONTINUE_BUTTON = "continueButton.AutoMoveTab";
    public static final String EXIT_BUTTON = "exit.AutoMoveTab";
    private final PlayPauseStepStopDriver playPauseStepStopDriver;

    @Inject
    public AutoMoveScreenDriver(MainScreen mainScreen, PlayPauseStepStopDriver playPauseStepStopDriver) {
        super(mainScreen, AUTO_MOVE_BUTTON);
        this.playPauseStepStopDriver = playPauseStepStopDriver;
    }

    public void cancel() {
        this.push(this.buttonNamed(EXIT_BUTTON));
        if (!Waiting.until((Waiting.ItHappens)new IsNotShowingAutomoveScreen(), (int)2500, (TimeUnit)TimeUnit.MILLISECONDS)) {
            throw new NotEnabled("The AutoMoveScreen was not closed");
        }
    }

    public void pressContinue() {
        this.push(this.buttonNamed(CONTINUE_BUTTON));
        if (!Waiting.until((Waiting.ItHappens)new IsNotShowingAutomoveScreen(), (int)2500, (TimeUnit)TimeUnit.MILLISECONDS)) {
            throw new NotEnabled("The AutoMoveScreen was not closed");
        }
    }

    public boolean performAutoMove() {
        this.longPushAutoMoveButton();
        boolean didMoveAllTheWay = this.isNotShowing(AUTO_MOVE_BUTTON);
        if (didMoveAllTheWay) {
            this.exitAutoMoveScreen();
        }
        return didMoveAllTheWay;
    }

    public boolean performAutoMoveAndContinue() {
        this.longPushAutoMoveButton();
        boolean didMoveAllTheWay = this.isNotShowing(AUTO_MOVE_BUTTON);
        if (didMoveAllTheWay) {
            this.playPauseStepStopDriver.programIsStopped();
            this.pressContinue();
        }
        return didMoveAllTheWay;
    }

    private void longPushAutoMoveButton() {
        this.longPush(this.buttonNamed(AUTO_MOVE_BUTTON), new Waiting.ItHappens(){

            public boolean itHappened() {
                return AutoMoveScreenDriver.this.isShowing(AutoMoveScreenDriver.CONTINUE_BUTTON);
            }
        }, 20);
    }

    public void selectManualMove() {
        this.push(this.buttonNamed(MANUAL_MOVE_BUTTON));
    }

    public boolean isShowingContinueButton() {
        return this.isShowing(CONTINUE_BUTTON);
    }

    public boolean isShowingCancelButton() {
        return this.isShowing(EXIT_BUTTON);
    }

    public boolean isShowingManualMoveButton() {
        return this.isShowing(MANUAL_MOVE_BUTTON);
    }

    public boolean isShowingAutoMoveButton() {
        return this.isShowing(AUTO_MOVE_BUTTON);
    }

    public boolean isNotShowingContinueButton() {
        return this.isNotShowing(CONTINUE_BUTTON);
    }

    public boolean isNotShowingManualMoveButton() {
        return this.isNotShowing(MANUAL_MOVE_BUTTON);
    }

    public boolean isNotShowing() {
        return this.isNotShowingManualMoveButton() && this.isNotShowingContinueButton();
    }

    public void exitAutoMoveScreen() {
        if (this.isShowingCancelButton()) {
            this.cancel();
        } else if (this.isShowingContinueButton()) {
            this.pressContinue();
        } else {
            throw new IllegalStateException("No 'cancel' or 'continue' buttons on auto move screen");
        }
        JemmyUtils.waitForIdle((int)3, (TimeUnit)TimeUnit.SECONDS);
    }

    private class IsNotShowingAutomoveScreen
    implements Waiting.ItHappens {
        private IsNotShowingAutomoveScreen() {
        }

        public boolean itHappened() {
            return AutoMoveScreenDriver.this.isNotShowing();
        }
    }
}

