/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.application.driver.pallet;

import com.ur.polyscope.driver.api.BaseDriver;
import com.ur.polyscope.driver.api.MainScreen;
import com.ur.polyscope.driver.api.dialog.DialogRegistry;
import com.ur.util.Waiting;
import java.util.concurrent.TimeUnit;
import org.netbeans.jemmy.operators.JTreeOperator;

abstract class AbstractPalletDriver
extends BaseDriver {
    protected final DialogRegistry dialogRegistry;

    AbstractPalletDriver(MainScreen mainScreen, String driverShowingComponentName, DialogRegistry dialogRegistry) {
        super(mainScreen, driverShowingComponentName);
        this.dialogRegistry = dialogRegistry;
    }

    public void navigateToTreeNode(String text) {
        if (!Waiting.until(() -> this.treeHasNode(text), (int)5, (TimeUnit)TimeUnit.SECONDS)) {
            throw new IllegalStateException("Unable to navigate to tree node named: " + text);
        }
        this.push(this.itemMatching(text, this.getProgramTree()));
    }

    public boolean treeHasNode(String text) {
        JTreeOperator tree = this.getProgramTree();
        return tree.findRow(text) >= 0;
    }

    public JTreeOperator getProgramTree() {
        this.selectProgramScreen();
        return this.treeNamed("programTree.ProgramPanel");
    }

    public void selectProgramScreen() {
        this.buttonNamed("programScreen.HeaderMenu").push();
    }

    protected static void assertTrue(String message, boolean value) {
        if (!value) {
            throw new AssertionError((Object)message);
        }
    }
}

