/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.application.driver.pallet;

import com.ur.pallet.common.i18n.TextResource;
import com.ur.pallet.common.i18n.impl.TextResourceImpl;
import com.ur.pallet.common.model.NamedUUID;
import com.ur.pallet.common.model.NamedWithVariable;
import com.ur.polyscope.application.driver.pallet.AbstractPalletDriver;
import com.ur.polyscope.application.driver.pallet.AutoMoveScreenDriver;
import com.ur.polyscope.driver.api.MainScreen;
import com.ur.polyscope.driver.api.dialog.DialogRegistry;
import com.ur.util.Waiting;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.netbeans.jemmy.operators.AbstractButtonOperator;
import org.netbeans.jemmy.operators.JComboBoxOperator;

public class AtEachScreenDriver
extends AbstractPalletDriver {
    private final TextResource textResource;
    private final AutoMoveScreenDriver autoMoveScreenDriver;
    private com.ur.polyscope.driver.api.move.AutoMoveScreenDriver aSd;

    @Inject
    public AtEachScreenDriver(MainScreen polyScopeUI, DialogRegistry dialogRegistry, TextResourceImpl textResource, com.ur.polyscope.driver.api.move.AutoMoveScreenDriver aSd, AutoMoveScreenDriver autoMoveScreenDriver) {
        super(polyScopeUI, "At Each Position", dialogRegistry);
        this.autoMoveScreenDriver = autoMoveScreenDriver;
        this.textResource = textResource;
        this.aSd = aSd;
    }

    public void navigateToMoveJ() {
        this.navigateToTreeNode("MoveJ");
    }

    public void navigateToMoveL() {
        this.navigateToTreeNode("MoveL");
    }

    public String getSelectedFeature() {
        JComboBoxOperator operator = this.comboBoxNamed("feature.G5MoveCard");
        return operator.getSelectedItem().toString();
    }

    public void navigateToAtEachNode() {
        this.navigateToTreeNode(this.textResource.atEachItem());
    }

    public void wizardNext() {
        this.push(this.buttonNamed("AtEachPositionProgramNodeView.next"));
    }

    public void wizardFinish() {
        this.push(this.buttonNamed("AtEachPositionProgramNodeView.finish"));
    }

    public void wizardCancel() {
        this.push(this.buttonNamed("AtEachPositionProgramNodeView.cancel"));
        boolean confirmationDialogShown = Waiting.until(() -> this.dialogRegistry.isDialogShown(this.textResource.warning()), (int)10, (TimeUnit)TimeUnit.SECONDS);
        AtEachScreenDriver.assertTrue("Confirmation dialog not shown", confirmationDialogShown);
        this.dialogRegistry.inDialog(this.textResource.warning()).pushButton("confirm.confirmMessageDialog");
    }

    public void teachWaypoint() {
        this.push(this.buttonNamed("AtEachPositionProgramNodeView.setWaypoint"));
        this.aSd.pushOkOnMoveTab();
    }

    public void moveToReferencePoint() {
        this.push(this.buttonNamed("AtEachPositionProgramNodeView.moveToWaypoint"));
        this.autoMoveScreenDriver.performAutoMoveAndContinue();
    }

    public void setBasePosition() {
        this.push(this.buttonNamed("AtEachPositionProgramNodeView.setPosition"));
        boolean confirmationDialogShown = Waiting.until(() -> this.dialogRegistry.isDialogShown(this.textResource.warning()), (int)10, (TimeUnit)TimeUnit.SECONDS);
        AtEachScreenDriver.assertTrue("Confirmation dialog not shown", confirmationDialogShown);
        this.dialogRegistry.inDialog(this.textResource.warning()).pushButton("confirm.confirmMessageDialog");
    }

    public void toggleWizard() {
        this.push(this.buttonNamed("AtEachPositionProgramNodeView.wizard"));
    }

    public String getSelectedBasePosition() {
        AbstractButtonOperator button = this.buttonNamed("AtEachPositionProgramNodeView.manual");
        if (button.isVisible()) {
            this.push(button);
        }
        JComboBoxOperator operator = this.comboBoxNamed("AtEachPositionProgramNodeView.positions");
        NamedUUID position = (NamedUUID)operator.getSelectedItem();
        return position.getName();
    }

    public List<String> getPossibleBasePositions() {
        ArrayList<String> result = new ArrayList<String>();
        JComboBoxOperator operator = this.comboBoxNamed("AtEachPositionProgramNodeView.positions");
        for (int i = 0; i < operator.getModel().getSize(); ++i) {
            NamedWithVariable position = (NamedWithVariable)operator.getModel().getElementAt(i);
            result.add(position.getVariable().getDisplayName());
        }
        return result;
    }
}

