/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.application.driver.pallet;

import com.ur.polyscope.driver.api.BaseDriver;
import com.ur.polyscope.driver.api.MainScreen;
import com.ur.polyscope.driver.api.NotEnabled;
import com.ur.polyscope.program.ProgramStateHolder;
import com.ur.polyscope.program.monitor.ProgramState;
import com.ur.util.Waiting;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

public class AutoMoveScreenDriver
extends BaseDriver {
    private static final String AUTOMOVE_BUTTON = "autoMoveButton.AutoMoveTab";
    private static final String CONTINUE_BUTTON = "continueButton.AutoMoveTab";
    private final ProgramStateHolder programStateHolder;

    @Inject
    public AutoMoveScreenDriver(MainScreen polyScopeUI, ProgramStateHolder programStateHolder) {
        super(polyScopeUI, AUTOMOVE_BUTTON);
        this.programStateHolder = programStateHolder;
    }

    private void pressContinue() {
        this.push(this.buttonNamed(CONTINUE_BUTTON));
        if (!Waiting.until(this::isNotShowing, (int)2500, (TimeUnit)TimeUnit.MILLISECONDS)) {
            throw new NotEnabled("The AutoMoveScreen was not closed");
        }
    }

    public boolean performAutoMoveAndContinue() {
        this.longPushAutoMoveButton();
        boolean didMoveAllTheWay = this.isNotShowing(AUTOMOVE_BUTTON);
        if (didMoveAllTheWay) {
            this.waitProgramState(ProgramState.STOPPED);
            this.pressContinue();
        }
        return didMoveAllTheWay;
    }

    private void waitProgramState(ProgramState state) {
        Waiting.until(() -> this.programStateHolder.getProgramState() == state, (int)5000, (int)100, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    private void longPushAutoMoveButton() {
        this.longPush(this.buttonNamed(AUTOMOVE_BUTTON), () -> this.isShowing(CONTINUE_BUTTON), 20);
    }

    public boolean isShowingManualMoveButton() {
        return this.isShowing("manualMoveButton.AutoMoveTab");
    }

    public boolean isShowingAutoMoveButton() {
        return this.isShowing(AUTOMOVE_BUTTON);
    }

    private boolean isNotShowingContinueButton() {
        return this.isNotShowing(CONTINUE_BUTTON);
    }

    private boolean isNotShowingManualMoveButton() {
        return this.isNotShowing("manualMoveButton.AutoMoveTab");
    }

    private boolean isNotShowing() {
        return this.isNotShowingManualMoveButton() && this.isNotShowingContinueButton();
    }
}

