/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.application.driver.pallet;

import com.ur.polyscope.application.driver.pallet.AbstractPalletDriver;
import com.ur.polyscope.driver.api.MainScreen;
import com.ur.polyscope.driver.api.dialog.DialogDriver;
import com.ur.polyscope.driver.api.dialog.DialogRegistry;
import com.ur.polyscope.driver.api.installation.InstallationScreenDriver;
import com.ur.util.Waiting;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import org.netbeans.jemmy.operators.JComponentOperator;

public class PalletPolyscopeDriver
extends AbstractPalletDriver {
    private final InstallationScreenDriver installationScreenDriver;

    @Inject
    PalletPolyscopeDriver(MainScreen mainScreen, String driverShowingComponentName, DialogRegistry dialogRegistry, InstallationScreenDriver installationScreenDriver) {
        super(mainScreen, driverShowingComponentName, dialogRegistry);
        this.installationScreenDriver = installationScreenDriver;
    }

    public void copyNode() {
        this.push(this.buttonNamed("copyAction.CopyNodeAction"));
    }

    public void cutNode() {
        this.push(this.buttonNamed("cutAction.CutNodeAction"));
    }

    public void pasteNode() {
        this.push(this.buttonNamed("pasteAction.PasteNodeAction"));
    }

    public void pushButtonInDialog(String dialogTitle, String button) {
        if (this.isDialogShown(dialogTitle)) {
            DialogDriver driver = this.dialogRegistry.inDialog(dialogTitle);
            driver.pushButton(button);
        }
    }

    public void goToInstallationVariables() {
        this.installationScreenDriver.select();
        this.push(this.buttonNamed("showInstallationVariablesAction.ImprovedInstallationVariablesTab"));
        Waiting.pause((long)2L, (TimeUnit)TimeUnit.SECONDS);
    }

    public boolean installationVariableExists(String variableName) {
        JComponentOperator op = this.componentNamed("ImprovedInstallationVariablesTab.variablesTable");
        JTable variablesTable = (JTable)op.getSource();
        TableModel model = variablesTable.getModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            for (int j = 0; j < model.getColumnCount(); ++j) {
                String variable = model.getValueAt(i, j).toString();
                if (!variable.equals(variableName)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isDialogShown(String title) {
        return this.dialogRegistry.isDialogShown(title);
    }
}

