/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.application.driver.pallet;

import com.ur.pallet.common.i18n.TextResource;
import com.ur.polyscope.application.driver.pallet.AbstractPalletDriver;
import com.ur.polyscope.driver.api.MainScreen;
import com.ur.polyscope.driver.api.dialog.DialogRegistry;
import com.ur.polyscope.driver.api.program.ProgramScreenDriver;
import com.ur.polyscope.driver.api.program.ProgramSectionName;
import com.ur.swing.text.driver.TextPickerOperator;
import com.ur.util.Waiting;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.netbeans.jemmy.operators.JCheckBoxOperator;

public class PalletScreenDriver
extends AbstractPalletDriver {
    private static final String TEMPLATES_SECTION = "wizardNodesSection.ProgramTab";
    private final TextResource textResource;
    private final ProgramScreenDriver programScreenDriver;

    @Inject
    public PalletScreenDriver(MainScreen polyscopeUI, DialogRegistry dialogRegistry, ProgramScreenDriver programScreenDriver, TextResource textResource) {
        super(polyscopeUI, "Pallet", dialogRegistry);
        this.programScreenDriver = programScreenDriver;
        this.textResource = textResource;
    }

    public void createPallet() {
        this.programScreenDriver.selectSection(ProgramSectionName.TEMPLATES);
        this.push(this.buttonNamed("wizardNodesSection.ProgramTab." + this.textResource.palletizing()));
        boolean palletCreated = Waiting.until(() -> this.treeHasNode("Pallet"), (int)4, (TimeUnit)TimeUnit.SECONDS);
        PalletScreenDriver.assertTrue("Pallet node was not created", palletCreated);
    }

    public void navigateToPalletNode() {
        this.navigateToPalletNode("Pallet");
    }

    public void navigateToPalletNode(String palletName) {
        this.navigateToTreeNode(palletName);
        Waiting.until(() -> this.isOnPalletNode(palletName), (int)2, (TimeUnit)TimeUnit.SECONDS);
        PalletScreenDriver.assertTrue("Unable to navigate to pallet node '" + palletName + "'", this.isOnPalletNode(palletName));
    }

    public void setPalletName(String palletName) {
        this.push(this.buttonNamed("rename.PalletProgramNodeView"));
        TextPickerOperator textPickerOperator = new TextPickerOperator();
        textPickerOperator.setTextInField(palletName);
        textPickerOperator.clickOk();
        textPickerOperator.waitToClose();
    }

    public void setPalletCounterVariableName(String palletName) {
        this.push(this.buttonNamed("renameCounter.PalletProgramNodeView"));
        TextPickerOperator textPickerOperator = new TextPickerOperator();
        textPickerOperator.setTextInField(palletName);
        textPickerOperator.clickOk();
        textPickerOperator.waitToClose();
    }

    public String getPalletName() {
        return this.labelNamed("PalletProgramNodeView.palletName").getText();
    }

    public String getReferenceFeatureName() {
        return this.comboBoxNamed("PalletProgramNodeView.feature").getSelectedItem().toString();
    }

    public String getCountingVariableName() {
        return this.labelNamed("PalletProgramNodeView.countingVariable").getText();
    }

    public void checkActions() {
        this.checkActionBefore();
        this.checkActionAfter();
    }

    public void checkActionAfter() {
        this.componentNamed("PalletProgramNodeView.actionAfter").clickMouse();
        Waiting.until(this::actionAfterChecked, (int)1, (TimeUnit)TimeUnit.SECONDS);
    }

    public void checkActionBefore() {
        this.componentNamed("PalletProgramNodeView.actionBefore").clickMouse();
        Waiting.until(this::actionBeforeChecked, (int)1, (TimeUnit)TimeUnit.SECONDS);
    }

    public void checkRememberTraversal() {
        this.componentNamed("PalletProgramNodeView.rememberTraversal").clickMouse();
    }

    public boolean hasActionBeforeNode() {
        this.navigateToTreeNode(this.textResource.actionBeforePalletizing());
        return true;
    }

    public boolean hasActionAfterNode() {
        this.navigateToTreeNode(this.textResource.actionAfterPalletizing());
        return true;
    }

    public boolean actionBeforeChecked() {
        JCheckBoxOperator operator = this.checkBoxNamed("PalletProgramNodeView.actionBefore");
        return operator.isSelected();
    }

    public boolean actionAfterChecked() {
        JCheckBoxOperator operator = this.checkBoxNamed("PalletProgramNodeView.actionAfter");
        return operator.isSelected();
    }

    public void deletePallet() {
        this.deletePallet("Pallet");
    }

    public void deletePallet(String palletName) {
        this.programScreenDriver.select();
        this.navigateToPalletNode(palletName);
        this.buttonNamed("deleteNode.DeleteNodeAction").push();
    }

    public void undo(int times) {
        for (int i = 0; i < times; ++i) {
            this.undo();
        }
    }

    public void undo() {
        this.buttonNamed("undoAction.UndoProgramAction").pushNoBlock();
        Waiting.pause((long)1L, (TimeUnit)TimeUnit.SECONDS);
    }

    public void redo(int times) {
        for (int i = 0; i < times; ++i) {
            this.redo();
        }
    }

    public void redo() {
        this.buttonNamed("redoAction.RedoProgramAction").pushNoBlock();
        Waiting.pause((long)1L, (TimeUnit)TimeUnit.SECONDS);
    }

    private boolean isOnPalletNode(String palletName) {
        return this.getPalletName().contains(palletName);
    }
}

