/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.application.driver.pallet;

import com.ur.pallet.common.i18n.TextResource;
import com.ur.pallet.common.i18n.impl.TextResourceImpl;
import com.ur.pallet.common.model.PatternType;
import com.ur.polyscope.application.driver.pallet.AbstractPalletDriver;
import com.ur.polyscope.driver.api.MainScreen;
import com.ur.polyscope.driver.api.dialog.DialogRegistry;
import com.ur.polyscope.driver.api.move.AutoMoveScreenDriver;
import com.ur.swing.number.driver.NumberKeyPadOperator;
import com.ur.swing.text.driver.TextPickerOperator;
import com.ur.util.Waiting;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.netbeans.jemmy.operators.JCheckBoxOperator;

public class PatternsScreenDriver
extends AbstractPalletDriver {
    private final TextResource textResource;
    private final AutoMoveScreenDriver autoMoveScreenDriver;

    @Inject
    public PatternsScreenDriver(MainScreen polyscopeUI, DialogRegistry dialogRegistry, TextResourceImpl textResource, AutoMoveScreenDriver autoMoveScreenDriver) {
        super(polyscopeUI, "Patterns", dialogRegistry);
        this.textResource = textResource;
        this.autoMoveScreenDriver = autoMoveScreenDriver;
    }

    public void navigateToPatternsNode() {
        this.navigateToTreeNode(this.textResource.patterns());
    }

    public void createAndNavigateToPattern(PatternType patternType) {
        this.navigateToPatternsNode();
        String buttonName = null;
        switch (patternType) {
            case LINE: {
                buttonName = "PatternsProgramNodeView.LineButton";
                break;
            }
            case GRID: {
                buttonName = "PatternsProgramNodeView.GridButton";
                break;
            }
            case IRREGULAR: {
                buttonName = "PatternsProgramNodeView.IrregularButton";
                break;
            }
        }
        this.push(this.buttonNamed(buttonName));
        this.navigateToPatternNode(patternType);
    }

    public void checkSeparatorBox() {
        this.componentNamed("PatternsProgramNodeView.SeparatorCheckbox").clickMouse();
        Waiting.until(this::separatorSelected, (int)1, (TimeUnit)TimeUnit.SECONDS);
    }

    public String getPatternName() {
        return this.labelNamed("PatternProgramNodeView.patternName").getText();
    }

    public void navigateToPatternNode(PatternType patternType) {
        this.navigateToTreeNode(this.getPatternSearchName(patternType));
    }

    private String getPatternSearchName(PatternType patternType) {
        switch (patternType) {
            case GRID: {
                return "Grid";
            }
            case LINE: {
                return "Line";
            }
            case IRREGULAR: {
                return "Irreg";
            }
        }
        return patternType.name();
    }

    public void setLineObjects(int objects) {
        this.enterNumber(objects, "PatternProgramNodeView.rows");
    }

    public void setRowsAndColumns(int rows, int columns) {
        this.enterNumber(rows, "PatternProgramNodeView.rows");
        this.enterNumber(columns, "PatternProgramNodeView.columns");
    }

    public String getObjects() {
        return this.getTextFieldValue("PatternProgramNodeView.rows");
    }

    public String getRows() {
        return this.getObjects();
    }

    public String getColumns() {
        return this.getTextFieldValue("PatternProgramNodeView.columns");
    }

    public boolean rowsAndColumnsHidden() {
        return !this.isShowing("PatternProgramNodeView.rows") && !this.isShowing("PatternProgramNodeView.columns");
    }

    public void deletePattern() {
        this.push(this.buttonNamed("PatternProgramNodeView.deletePattern"));
    }

    public void definePosition(String positionNameMatching) {
        this.navigateToTreeNode(positionNameMatching);
        this.push(this.buttonNamed("PositionProgramNodeView.setPosition"));
        this.autoMoveScreenDriver.pushOkOnMoveTab();
    }

    public void renamePosition(String oldName, String newName) {
        this.navigateToTreeNode(oldName);
        Waiting.pause((long)1L, (TimeUnit)TimeUnit.SECONDS);
        this.push(this.buttonNamed("rename.PositionProgramNodeView"));
        TextPickerOperator textPickerOperator = new TextPickerOperator();
        textPickerOperator.setTextInField(newName);
        textPickerOperator.clickOk();
    }

    private void enterNumber(int rows, String componentName) {
        this.numberFieldNamed(componentName).punchInKeypad(Integer.toString(rows));
    }

    private boolean separatorSelected() {
        JCheckBoxOperator operator = this.checkBoxNamed("PatternsProgramNodeView.SeparatorCheckbox");
        return operator.isSelected();
    }

    private NumberKeyPadOperator numberFieldNamed(String withName) {
        return new NumberKeyPadOperator(this.textFieldNamed(withName));
    }
}

