/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.application.driver.payload;

import com.ur.polyscope.application.driver.payload.PayloadWizardDriver;
import com.ur.polyscope.application.driver.payload.names.CogInputFactory;
import com.ur.polyscope.application.driver.payload.names.InstallationPayloadMenuExtension;
import com.ur.polyscope.application.driver.payload.names.InstallationPayloadsListView;
import com.ur.polyscope.application.driver.payload.names.MomentOfInertiaInputFactory;
import com.ur.polyscope.application.driver.payload.names.PayloadEstimationButtonPanel;
import com.ur.polyscope.application.driver.payload.names.PayloadInertiaView;
import com.ur.polyscope.application.driver.payload.names.PayloadsListCreator;
import com.ur.polyscope.application.driver.payload.names.WeightInputFactory;
import com.ur.polyscope.driver.api.BaseDriver;
import com.ur.polyscope.driver.api.MainScreen;
import com.ur.polyscope.payload.common.InstallationPayloadComponent;
import com.ur.swing.number.driver.NumberKeyPadOperator;
import com.ur.swing.text.driver.TextPickerOperator;
import com.ur.util.Waiting;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.netbeans.jemmy.operators.JComboBoxOperator;

public class PayloadInstallationDriver
extends BaseDriver {
    @Inject
    public PayloadInstallationDriver(MainScreen mainScreen) {
        super(mainScreen, InstallationPayloadsListView.ADD_PAYLOAD);
    }

    public void selectPayloadScreen() {
        this.push(this.buttonNamed(InstallationPayloadMenuExtension.PAYLOAD_BUTTON_NAME));
        this.isShowing();
    }

    public void renamePayload(String newName) {
        this.push(this.buttonNamed(InstallationPayloadsListView.RENAME_PAYLOAD));
        TextPickerOperator textPicker = new TextPickerOperator();
        textPicker.setTextSelection(0, 15);
        textPicker.clickBackSpace(1);
        textPicker.type(newName);
    }

    public void selectPayload(int index) {
        JComboBoxOperator combobox = this.comboBoxNamed(PayloadsListCreator.AVAILABLE_PAYLOADS);
        combobox.selectItem(index);
    }

    public void selectPayload(String payloadName) {
        JComboBoxOperator combobox = this.comboBoxNamed(PayloadsListCreator.AVAILABLE_PAYLOADS);
        combobox.selectItem(payloadName);
    }

    public void clickSetDefault() {
        this.push(this.buttonNamed(InstallationPayloadsListView.APPLY_SELECTED_PAYLOAD));
    }

    public void clickSetActive() {
        this.push(this.buttonNamed(InstallationPayloadsListView.SET_ACTIVE_PAYLOAD));
    }

    public void addPayload() {
        InstallationPayloadComponent selectedPayload = this.getSelectedPayload();
        this.push(this.buttonNamed(InstallationPayloadsListView.ADD_PAYLOAD));
        Waiting.until(() -> !selectedPayload.equals((Object)this.getSelectedPayload()), (int)5, (TimeUnit)TimeUnit.SECONDS);
    }

    public void removePayload() {
        this.push(this.buttonNamed(InstallationPayloadsListView.REMOVE_PAYLOAD));
    }

    public void setMass(double value) {
        NumberKeyPadOperator numberKeyPadOperator = new NumberKeyPadOperator(this.textFieldNamed(WeightInputFactory.WEIGHT_FIELD_NAME));
        numberKeyPadOperator.punchInKeypad(Double.toString(value));
    }

    public void setCoG(double x, double y, double z) {
        NumberKeyPadOperator numberKeyPadOperator = new NumberKeyPadOperator(this.textFieldNamed(CogInputFactory.COG_FIELD_NAMES[0]));
        numberKeyPadOperator.punchInKeypad(Double.toString(x));
        numberKeyPadOperator = new NumberKeyPadOperator(this.textFieldNamed(CogInputFactory.COG_FIELD_NAMES[1]));
        numberKeyPadOperator.punchInKeypad(Double.toString(y));
        numberKeyPadOperator = new NumberKeyPadOperator(this.textFieldNamed(CogInputFactory.COG_FIELD_NAMES[2]));
        numberKeyPadOperator.punchInKeypad(Double.toString(z));
    }

    public PayloadWizardDriver startMeasureWizard() {
        this.push(this.buttonNamed(PayloadEstimationButtonPanel.PAYLOAD_ESTIMATION));
        return new PayloadWizardDriver(this.mainScreen);
    }

    public void checkCustomInertia(boolean value) {
        this.checkBoxNamed(PayloadInertiaView.USE_CUSTOM_INERTIA_NAME).changeSelection(true);
    }

    public void setInertiaValue(double xx, double yy, double zz, double xy, double xz, double yz) {
        NumberKeyPadOperator numberKeyPadOperator = new NumberKeyPadOperator(this.textFieldNamed(MomentOfInertiaInputFactory.INERTIA_FIELD_NAMES[0]));
        numberKeyPadOperator.punchInKeypad(Double.toString(xx));
        numberKeyPadOperator = new NumberKeyPadOperator(this.textFieldNamed(MomentOfInertiaInputFactory.INERTIA_FIELD_NAMES[1]));
        numberKeyPadOperator.punchInKeypad(Double.toString(yy));
        numberKeyPadOperator = new NumberKeyPadOperator(this.textFieldNamed(MomentOfInertiaInputFactory.INERTIA_FIELD_NAMES[2]));
        numberKeyPadOperator.punchInKeypad(Double.toString(zz));
        numberKeyPadOperator = new NumberKeyPadOperator(this.textFieldNamed(MomentOfInertiaInputFactory.INERTIA_FIELD_NAMES[3]));
        numberKeyPadOperator.punchInKeypad(Double.toString(xy));
        numberKeyPadOperator = new NumberKeyPadOperator(this.textFieldNamed(MomentOfInertiaInputFactory.INERTIA_FIELD_NAMES[4]));
        numberKeyPadOperator.punchInKeypad(Double.toString(xz));
        numberKeyPadOperator = new NumberKeyPadOperator(this.textFieldNamed(MomentOfInertiaInputFactory.INERTIA_FIELD_NAMES[5]));
        numberKeyPadOperator.punchInKeypad(Double.toString(yz));
    }

    public void setInertiaValue(double value, InertiaDimensions dim) {
        NumberKeyPadOperator numberKeyPadOperator = new NumberKeyPadOperator(this.textFieldNamed(MomentOfInertiaInputFactory.INERTIA_FIELD_NAMES[dim.ordinal()]));
        numberKeyPadOperator.punchInKeypad(Double.toString(value));
    }

    public InstallationPayloadComponent getSelectedPayload() {
        return (InstallationPayloadComponent)this.comboBoxNamed(PayloadsListCreator.AVAILABLE_PAYLOADS).getSelectedItem();
    }

    public static enum InertiaDimensions {
        XX,
        YY,
        ZZ,
        XY,
        XZ,
        YZ;

    }
}

