/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.application.driver.payload;

import com.ur.polyscope.application.driver.payload.names.AddSetPayloadNodeAction;
import com.ur.polyscope.application.driver.payload.names.CogInputFactory;
import com.ur.polyscope.application.driver.payload.names.PayloadReferenceView;
import com.ur.polyscope.application.driver.payload.names.SetPayloadSelectionView;
import com.ur.polyscope.application.driver.payload.names.WeightInputFactory;
import com.ur.polyscope.driver.api.BaseDriver;
import com.ur.polyscope.driver.api.MainScreen;
import com.ur.polyscope.payload.common.PayloadComponent;
import com.ur.swing.number.driver.NumberKeyPadOperator;
import com.ur.util.Waiting;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.netbeans.jemmy.operators.JComboBoxOperator;
import org.netbeans.jemmy.operators.JLabelOperator;

public class PayloadProgramDriver
extends BaseDriver {
    @Inject
    public PayloadProgramDriver(MainScreen mainScreen) {
        super(mainScreen, PayloadReferenceView.SET_ACTIVE_PAYLOAD);
    }

    public void addPayloadNode() {
        this.push(this.buttonNamed(AddSetPayloadNodeAction.ADD_SET_PAYLOAD_NODE));
    }

    public void selectPayload(int index) {
        this.comboBoxNamed(SetPayloadSelectionView.COMBO_BOX_NAME).selectItem(index);
    }

    public void selectPayload(String name) {
        this.comboBoxNamed(SetPayloadSelectionView.COMBO_BOX_NAME).selectItem(name);
    }

    public void selectCustomPayload() {
        JComboBoxOperator comboBoxOperator = this.comboBoxNamed(SetPayloadSelectionView.COMBO_BOX_NAME);
        int itemCount = comboBoxOperator.getItemCount();
        comboBoxOperator.selectItem(itemCount - 1);
    }

    public void setMass(double value) {
        NumberKeyPadOperator numberKeyPadOperator = new NumberKeyPadOperator(this.textFieldNamed(WeightInputFactory.WEIGHT_FIELD_NAME));
        numberKeyPadOperator.punchInKeypad(Double.toString(value));
    }

    public void setCoG(double x, double y, double z) {
        NumberKeyPadOperator numberKeyPadOperator = new NumberKeyPadOperator(this.textFieldNamed(CogInputFactory.COG_FIELD_NAMES[0]));
        numberKeyPadOperator.punchInKeypad(Double.toString(x));
        numberKeyPadOperator = new NumberKeyPadOperator(this.textFieldNamed(CogInputFactory.COG_FIELD_NAMES[1]));
        numberKeyPadOperator.punchInKeypad(Double.toString(y));
        numberKeyPadOperator = new NumberKeyPadOperator(this.textFieldNamed(CogInputFactory.COG_FIELD_NAMES[2]));
        numberKeyPadOperator.punchInKeypad(Double.toString(z));
    }

    public void clickSetNow() {
        this.push(this.buttonNamed(PayloadReferenceView.SET_ACTIVE_PAYLOAD));
    }

    public PayloadComponent getSelectedPayload() {
        return (PayloadComponent)this.comboBoxNamed(SetPayloadSelectionView.COMBO_BOX_NAME).getSelectedItem();
    }

    private boolean hasWarningOrErrorMessageAs(String message) {
        return Waiting.until(() -> {
            JLabelOperator label = this.labelNamed(PayloadReferenceView.PAYLOAD_WARNING_LABEL);
            return label.getText().contains(message);
        }, (int)5, (TimeUnit)TimeUnit.SECONDS);
    }

    public boolean hasRatedPayloadWarning() {
        return this.hasWarningOrErrorMessageAs("Rated payload of 5.000 kg exceeded");
    }

    public boolean hasRememberPayloadWarning() {
        return this.hasWarningOrErrorMessageAs("Remember to set the total payload mass");
    }

    public boolean hasErrorInInstallationPayloadMsg() {
        return this.hasWarningOrErrorMessageAs("The payload has an error in the installation");
    }

    public boolean hasPayloadCogComboAffectPerformanceWarning() {
        return this.hasWarningOrErrorMessageAs("The current combination of payload and CoG may affect robot performance");
    }
}

