/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.application.driver.program;

import com.ur.polyscope.application.driver.program.ProgramDriverBase;
import com.ur.polyscope.application.driver.program.operator.ExpressionPickerOperator;
import com.ur.polyscope.driver.api.MainScreen;
import com.ur.util.Waiting;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.netbeans.jemmy.operators.AbstractButtonOperator;
import org.netbeans.jemmy.operators.JTextComponentOperator;
import org.netbeans.jemmy.operators.Operator;

public class MoveDirectionDriver
extends ProgramDriverBase {
    public static final String USE_SHARED_FEATURE_BUTTON = "MoveDirectionCard.useSharedFeature";
    public static final String USE_CUSTOM_FEATURE_BUTTON = "MoveDirectionCard.useCustomFeature";
    public static final String USE_DIRECTION_COMBOBOX_BUTTON = "MoveDirectionCard.useDirectionCombobox";
    public static final String USE_EXPRESSION_BUTTON = "MoveDirectionCard.useExpression";
    public static final String USE_SHARED_TOOL_PARAMETERS_BUTTON = "MoveDirectionCard.useSharedToolParameters";
    public static final String USE_CUSTOM_TOOL_PARAMETERS_BUTTON = "MoveDirectionCard.useCustomToolParameters";
    public static final String FEATURE_COMBOBOX = "MoveDirectionCard.featureCombobox";
    public static final String DIRECTION_COMBOBOX = "MoveDirectionCard.directionCombobox";
    public static final String EXPRESSION_EDITOR = "MoveDirectionCard.expressionEditor";
    public static final String SPEED_NUMBERFIELD = "MoveDirectionCard.speedNumberField";
    public static final String ACCELERATION_NUMBERFIELD = "MoveDirectionCard.accelerationNumberField";
    public static final String ADD_MOVE_DIRECTION = "addDirectionNode.AddMoveDirectionNodeAction";

    @Inject
    public MoveDirectionDriver(MainScreen mainScreen) {
        super(mainScreen, "MoveDirectionDriver");
    }

    public void addMoveDirectionNode() {
        if (!this.isShowing(ADD_MOVE_DIRECTION)) {
            AbstractButtonOperator header = this.buttonNamed("basicNodesSection.ProgramTab");
            this.push(header);
        }
        this.push(this.buttonNamed(ADD_MOVE_DIRECTION));
    }

    public void useSharedFeature() {
        this.push(this.buttonNamed(USE_SHARED_FEATURE_BUTTON));
    }

    public void useCustomFeature() {
        this.push(this.buttonNamed(USE_CUSTOM_FEATURE_BUTTON));
    }

    public void useDirectionCombobox() {
        this.push(this.buttonNamed(USE_DIRECTION_COMBOBOX_BUTTON));
    }

    public void useExpressionEditor() {
        this.push(this.buttonNamed(USE_EXPRESSION_BUTTON));
    }

    public void useSharedToolParameters() {
        this.push(this.buttonNamed(USE_SHARED_TOOL_PARAMETERS_BUTTON));
    }

    public void useCustomToolParameters() {
        this.push(this.buttonNamed(USE_CUSTOM_TOOL_PARAMETERS_BUTTON));
    }

    public void selectCustomFeature(String featureName) {
        this.setComboFromName(FEATURE_COMBOBOX, featureName);
    }

    public void selectDirection(String directionName) {
        this.setComboFromName(DIRECTION_COMBOBOX, directionName);
    }

    public void setExpression(String expression) {
        Waiting.until((Waiting.ItHappens)new Waiting.ItHappens(){

            public boolean itHappened() {
                return MoveDirectionDriver.this.textFieldNamed(MoveDirectionDriver.EXPRESSION_EDITOR).isEnabled();
            }
        }, (int)2, (TimeUnit)TimeUnit.SECONDS);
        ExpressionPickerOperator operator = new ExpressionPickerOperator((JTextComponentOperator)this.textFieldNamed(EXPRESSION_EDITOR));
        operator.typeFullExpression(expression);
        operator.clickOk();
    }

    public String getExpression() {
        return this.textFieldNamed(EXPRESSION_EDITOR).getText();
    }

    public void setSpeed(int speed) {
        this.clearAndType(speed, SPEED_NUMBERFIELD);
    }

    public void setAcceleration(int acceleration) {
        this.clearAndType(acceleration, ACCELERATION_NUMBERFIELD);
    }

    public double getSpeed() {
        return Double.parseDouble(this.textFieldNamed(SPEED_NUMBERFIELD).getText());
    }

    public double getAcceleration() {
        return Double.parseDouble(this.textFieldNamed(ACCELERATION_NUMBERFIELD).getText());
    }

    private void setComboFromName(String comboBoxName, String itemName) {
        int index = this.comboBoxNamed(comboBoxName).findItemIndex(itemName, Operator.getDefaultStringComparator());
        this.comboBoxNamed(comboBoxName).setSelectedIndex(index);
    }
}

