/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.application.driver.program;

import com.ur.polyscope.application.driver.program.ProgramDriverBase;
import com.ur.polyscope.driver.api.MainScreen;
import com.ur.polyscope.program.ProgramStateHolder;
import com.ur.polyscope.program.control.ShowingToolTipListener;
import com.ur.polyscope.program.monitor.ProgramState;
import com.ur.swing.DisplayMessageFactory;
import com.ur.util.Waiting;
import com.ur.util.event.EventNotificationService;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

public class PlayPauseStepStopDriver
extends ProgramDriverBase {
    public static final String PLAY_BUTTON_NAME = "program_run";
    public static final String STOP_BUTTON_NAME = "stopButton.Dashboard";
    public static final String STEP_BUTTON_NAME = "program_step.DashBoard";
    public static final String PLAY_FROM_BEGINNING_NAME = "Play_from_beginning";
    public static final String PLAY_FROM_SELECTION_NAME = "Play_from_selection";
    private static final String BIG_PLAY_PAUSE_BUTTON_NAME = "bigPlayPauseButton";
    private static final String BIG_STOP_BUTTON_NAME = "bigStopButton";
    private static final int DEFAULT_TIMEOUT = 5;
    private final ProgramStateHolder programStateHolder;
    private boolean oldEnabled;
    private boolean toolTipIsShowing;

    @Inject
    PlayPauseStepStopDriver(MainScreen mainScreen, ProgramStateHolder programStateHolder) {
        super(mainScreen, PLAY_BUTTON_NAME);
        this.programStateHolder = programStateHolder;
    }

    private void pressPlay() {
        this.toolTipIsShowing = false;
        this.oldEnabled = DisplayMessageFactory.testingGetEnablement();
        DisplayMessageFactory.testingSetEnablement((boolean)true);
        this.push(this.buttonNamed(PLAY_BUTTON_NAME));
        this.programIsPlaying();
    }

    private void pressBigPlay() {
        this.toolTipIsShowing = false;
        this.oldEnabled = DisplayMessageFactory.testingGetEnablement();
        DisplayMessageFactory.testingSetEnablement((boolean)true);
        this.push(this.buttonNamed(BIG_PLAY_PAUSE_BUTTON_NAME));
        this.programIsPlaying();
    }

    private void pressPlayDone() {
        DisplayMessageFactory.testingSetEnablement((boolean)this.oldEnabled);
        EventNotificationService.unregister((Object)((Object)this), ShowingToolTipListener.class);
    }

    public void showPlayToolTip() {
        EventNotificationService.register((Object)((Object)this), ShowingToolTipListener.class, (Object)new JustShowToolTip());
        this.oldEnabled = DisplayMessageFactory.testingGetEnablement();
        DisplayMessageFactory.testingSetEnablement((boolean)true);
        this.push(this.buttonNamed(PLAY_BUTTON_NAME));
        Waiting.until((Waiting.ItHappens)this.isShowingToolTip(), (int)1, (TimeUnit)TimeUnit.SECONDS);
    }

    public void closePlayToolTip() {
        if (this.toolTipIsShowing) {
            this.mainScreen.clickMouse(1, 1, 1);
            this.toolTipIsShowing = false;
        }
    }

    public void playProgramFromStart() {
        EventNotificationService.register((Object)((Object)this), ShowingToolTipListener.class, (Object)new ToolTipListenerTemplate(PLAY_FROM_BEGINNING_NAME));
        this.pressPlay();
    }

    public void playProgramFromBigButton() {
        EventNotificationService.register((Object)((Object)this), ShowingToolTipListener.class, (Object)new ToolTipListenerTemplate(PLAY_FROM_BEGINNING_NAME));
        this.pressBigPlay();
    }

    public void playProgramFromSelection() {
        EventNotificationService.register((Object)((Object)this), ShowingToolTipListener.class, (Object)new ToolTipListenerTemplate(PLAY_FROM_SELECTION_NAME));
        this.pressPlay();
    }

    public void stepProgram() {
        this.push(this.buttonNamed(STEP_BUTTON_NAME));
    }

    public boolean canStepProgram() {
        return this.buttonNamed(STEP_BUTTON_NAME).isEnabled();
    }

    public void pauseProgram() {
        if (this.programStateHolder.getProgramState() != ProgramState.PLAYING) {
            throw new RuntimeException("Program was not playing, state was: " + this.programStateHolder.getProgramState());
        }
        this.push(this.buttonNamed(PLAY_BUTTON_NAME));
        this.programIsPaused();
    }

    public void stopProgram() {
        this.push(this.buttonNamed(STOP_BUTTON_NAME));
        this.programIsStopped();
    }

    public boolean programIsPlaying() {
        return Waiting.until((Waiting.ItHappens)this.isPlaying(), (int)5, (TimeUnit)TimeUnit.SECONDS);
    }

    public boolean programIsPaused() {
        return Waiting.until((Waiting.ItHappens)this.isPaused(), (int)5, (TimeUnit)TimeUnit.SECONDS);
    }

    public boolean programIsStopped() {
        return Waiting.until((Waiting.ItHappens)this.isStopped(), (int)5, (TimeUnit)TimeUnit.SECONDS);
    }

    public Waiting.ItHappens isPlaying() {
        return () -> this.programStateHolder.getProgramState() == ProgramState.PLAYING;
    }

    public Waiting.ItHappens isPaused() {
        return () -> this.programStateHolder.getProgramState() == ProgramState.PAUSED;
    }

    public Waiting.ItHappens isStopped() {
        return () -> this.programStateHolder.getProgramState() == ProgramState.STOPPED;
    }

    public Waiting.ItHappens isShowingToolTip() {
        return () -> this.toolTipIsShowing;
    }

    public void stopProgramFromBigButton() {
        this.push(this.buttonNamed(BIG_STOP_BUTTON_NAME));
        this.programIsStopped();
    }

    private class JustShowToolTip
    implements ShowingToolTipListener {
        private JustShowToolTip() {
        }

        public void toolTipShown() {
            PlayPauseStepStopDriver.this.toolTipIsShowing = true;
            PlayPauseStepStopDriver.this.pressPlayDone();
        }

        public void toolTipSkipped() {
            PlayPauseStepStopDriver.this.pressPlayDone();
        }

        public void toolTipClosed() {
        }
    }

    private class ToolTipListenerTemplate
    implements ShowingToolTipListener {
        private final String buttonName;

        ToolTipListenerTemplate(String buttonName) {
            this.buttonName = buttonName;
        }

        public void toolTipShown() {
            PlayPauseStepStopDriver.this.componentNamed(this.buttonName).clickMouse();
            PlayPauseStepStopDriver.this.toolTipIsShowing = true;
            PlayPauseStepStopDriver.this.pressPlayDone();
        }

        public void toolTipSkipped() {
            PlayPauseStepStopDriver.this.pressPlayDone();
        }

        public void toolTipClosed() {
        }
    }
}

