/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.application.driver.program;

import com.ur.polyscope.application.driver.program.ProgramDriverBase;
import com.ur.polyscope.driver.api.MainScreen;
import com.ur.polyscope.program.nodes.ProgramNode;
import com.ur.swing.dialog.URDialogType;
import com.ur.util.Waiting;
import java.awt.Component;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.tree.TreePath;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JTreeOperator;

public class ProgramTreeManipulationDriver
extends ProgramDriverBase {
    public static final String PROGRAM_TREE = "programTree.ProgramPanel";
    public static final String HELP_ID = "HelpId";
    public static final String INTERNAL_NAME = "InternalName";
    private static final String LEFT_ARROW_KEY_MESSAGE_DIALOG_PANEL = "leftArrowKey.MessageDialogPanel";
    private static final String RIGHT_ARROW_KEY_MESSAGE_DIALOG_PANEL = "rightArrowKey.MessageDialogPanel";

    @Inject
    public ProgramTreeManipulationDriver(MainScreen mainScreen) {
        super(mainScreen, PROGRAM_TREE);
    }

    public void selectNode(int rowNumber) {
        JTreeOperator treeOperator = this.treeNamed(PROGRAM_TREE);
        TreePath path = treeOperator.getPathForRow(rowNumber);
        treeOperator.clickOnPath(path);
    }

    public ProgramNode getProgramNodeAt(int rowNumber) {
        JTreeOperator treeOperator = this.treeNamed(PROGRAM_TREE);
        TreePath path = treeOperator.getPathForRow(rowNumber);
        treeOperator.clickOnPath(path);
        Object component = path.getLastPathComponent();
        return (ProgramNode)component;
    }

    public boolean copy() {
        return this.pressButton(this.findButtonByProperty(HELP_ID, "gui:program_copy"));
    }

    public boolean paste() {
        return this.pressButton(this.findButtonByProperty(HELP_ID, "gui:program_paste"));
    }

    public boolean cut() {
        return this.pressButton(this.findButtonByProperty(HELP_ID, "gui:program_cut"));
    }

    public boolean suppress() {
        return this.pressButton(this.findButtonByProperty(HELP_ID, "gui:program_suppress"));
    }

    public boolean delete() {
        return this.pressButton(this.findButtonByProperty(HELP_ID, "gui:program_delete"));
    }

    public boolean redo() {
        return this.pressButton(this.findButtonByProperty(INTERNAL_NAME, "redoAction.RedoProgramAction"));
    }

    public boolean undo() {
        return this.pressButton(this.findButtonByProperty(INTERNAL_NAME, "redoAction.UndoProgramAction"));
    }

    public boolean closeMessagePopupOk() {
        if (!this.waitUntilDialogueIsShowing()) {
            return false;
        }
        this.push(this.buttonNamed(URDialogType.MESSAGE.getDialogName(), RIGHT_ARROW_KEY_MESSAGE_DIALOG_PANEL));
        return this.waitUntilDialogueIsHidden();
    }

    public boolean closeMessagePopupCancel() {
        if (!this.waitUntilDialogueIsShowing()) {
            return false;
        }
        this.push(this.buttonNamed(URDialogType.MESSAGE.getDialogName(), LEFT_ARROW_KEY_MESSAGE_DIALOG_PANEL));
        return this.waitUntilDialogueIsHidden();
    }

    private boolean waitUntilDialogueIsHidden() {
        return Waiting.until((Waiting.ItHappens)new Waiting.ItHappens(){

            public boolean itHappened() {
                return !ProgramTreeManipulationDriver.this.isShowingDialogue();
            }
        }, (int)3, (TimeUnit)TimeUnit.SECONDS);
    }

    private boolean waitUntilDialogueIsShowing() {
        return Waiting.until((Waiting.ItHappens)new Waiting.ItHappens(){

            public boolean itHappened() {
                return ProgramTreeManipulationDriver.this.isShowingDialogue();
            }
        }, (int)3, (TimeUnit)TimeUnit.SECONDS);
    }

    private boolean isShowingDialogue() {
        return this.isShowing(URDialogType.MESSAGE.getDialogName(), RIGHT_ARROW_KEY_MESSAGE_DIALOG_PANEL);
    }

    private JButtonOperator findButtonByProperty(final String key, final String value) {
        return new JButtonOperator((ContainerOperator)this.mainScreen, (ComponentChooser)new JButtonOperator.JButtonFinder(new ComponentChooser(){

            public boolean checkComponent(Component component) {
                if (!(component instanceof JButton)) {
                    return false;
                }
                JButton btn = (JButton)component;
                Action action = btn.getAction();
                if (action == null) {
                    return false;
                }
                return value.equals(action.getValue(key));
            }

            public String getDescription() {
                return "find button with property " + key + " == " + value;
            }
        }));
    }

    private boolean pressButton(JButtonOperator btn) {
        if (!btn.isEnabled()) {
            return false;
        }
        btn.press();
        return true;
    }
}

