/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.application.driver.program;

import com.ur.polyscope.application.driver.program.ProgramDriverBase;
import com.ur.polyscope.driver.api.MainScreen;
import javax.inject.Inject;
import org.netbeans.jemmy.operators.AbstractButtonOperator;
import org.netbeans.jemmy.operators.Operator;

public class SetNodeDriver
extends ProgramDriverBase {
    public static final String ADD_SET_NODE = "addSetNode.AddSetNodeAction";
    public static final String TEST_NODE = "ActionCard.testNode";
    public static final String INCREMENT_SELECTION_ID = "ActionCard.incrementSelectionId";
    public static final String INCREMENT_VARIABLE_SELECTION_ID = "ActionCard.incrementVariableSelectionId";
    public static final String PAYLOAD_CHECKBOX_ID = "ActionCard.setPayloadCheckboxId";
    public static final String USE_TCP_AS_COG_CHECKBOX_ID = "ActionCard.useTcpAsCogCheckboxId";
    public static final String DIGITAL_OUTPUT_SELECTION = "ActionCard.digitalOutputSelection";
    public static final String ANALOG_OUTPUT_SELECTION = "ActionCard.analogOutputSelection";
    public static final String OUTPUT_EXPRESSION_SELECTION = "ActionCard.outputExpressionSelection";
    public static final String SINGLE_DIGITAL_PULSE_SELECTION = "ActionCard.singleDigitalPulseSelection";
    public static final String ANALOG_VALUE = "ActionCard.analogValue";
    public static final String DIGITAL_OUTPUT_VALUE = "ActionCard.digitalOutputValue";
    public static final String NO_ACTION = "ActionCard.noAction";
    public static final String DIGITAL_OUTPUT = "ActionCard.digitalOutput";
    public static final String ANALOG_OUTPUT = "ActionCard.analogOutput";
    public static final String OUTPUT_EXPRESSION = "ActionCard.outputExpression";
    public static final String SINGLE_DIGITAL_PULSE = "ActionCard.singleDigitalPulse";
    public static final String SINGLE_DIGITAL_PULSE_TIME = "ActionCard.singleDigitalPulseTime";
    public static final String DEFAULT_OUTPUT_NAME = "digital_out";

    @Inject
    public SetNodeDriver(MainScreen mainScreen) {
        super(mainScreen, ADD_SET_NODE);
    }

    public void newSetNode() {
        this.push(this.buttonNamed(ADD_SET_NODE));
    }

    public void selectSetNodeAction(String name) {
        this.push((AbstractButtonOperator)this.radioButtonNamed(name));
    }

    public boolean isActionSelected(String name) {
        return this.radioButtonNamed(name).isSelected();
    }

    public void setAnalogOutput(int comboboxIndex) {
        this.comboBoxNamed(ANALOG_OUTPUT_SELECTION).setSelectedIndex(comboboxIndex);
    }

    public void setPulseOutput(int pin) {
        this.setComboFromName(SINGLE_DIGITAL_PULSE_SELECTION, "digital_out[" + pin + "]");
    }

    public void setAnalogValue(int number) {
        this.clearAndType(number, ANALOG_VALUE);
    }

    public void setPulseTime(int number) {
        this.clearAndType(number, SINGLE_DIGITAL_PULSE_TIME);
    }

    public double getAnalogValue() {
        return Double.parseDouble(this.textFieldNamed(ANALOG_VALUE).getText());
    }

    public double getPulseTime() {
        return Integer.parseInt(this.textFieldNamed(SINGLE_DIGITAL_PULSE_TIME).getText());
    }

    public void setDigitalOutputSelection(int pin) {
        this.setComboFromName(DIGITAL_OUTPUT_SELECTION, "digital_out[" + pin + "]");
    }

    public void setDigitalValue(int value) {
        this.comboBoxNamed(DIGITAL_OUTPUT_VALUE).setSelectedIndex(value);
    }

    private void setComboFromName(String comboBoxName, String itemName) {
        int index = this.comboBoxNamed(comboBoxName).findItemIndex(itemName, Operator.getDefaultStringComparator());
        this.comboBoxNamed(comboBoxName).setSelectedIndex(index);
    }
}

