/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.application.driver.program;

import com.ur.polyscope.application.driver.program.ProgramDriverBase;
import com.ur.polyscope.application.driver.program.UntilContactDetectionDriver;
import com.ur.polyscope.application.driver.program.operator.ExpressionPickerOperator;
import com.ur.polyscope.driver.api.MainScreen;
import com.ur.swing.number.driver.NumberKeyPadOperator;
import com.ur.util.Waiting;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.netbeans.jemmy.operators.AbstractButtonOperator;
import org.netbeans.jemmy.operators.JTextComponentOperator;
import org.netbeans.jemmy.operators.Operator;

public class UntilNodeDriver
extends ProgramDriverBase {
    public static final String UNTIL_CARD = "UntilCard";
    public static final String ADD_UNTIL = "addUntil.AddUntilCardContribution";
    public static final String UNTIL_EXPRESSION_BUTTON = "UntilExpressionNodeContribution.UntilCard";
    public static final String UNTIL_DISTANCE_BUTTON = "UntilDistanceNodeContribution.UntilCard";
    public static final String UNTIL_CONTACT_DETECTION = "UntilContactDetectionNodeContribution.UntilCard";
    public static final String UNTIL_REACHED_WAYPOINT = "UntilReachedWaypointNodeContribution.UntilCard";
    public static final String UNTIL_IO = "UntilIONodeContribution.UntilCard";
    public static final String ADD_ACTIONS_SWITCH = "addActions.UntilCard";
    public static final String EXPRESSION_EDITOR = "expressionEditorButton.UntilExpressionCard";
    public static final String DECELERATION_VALUE = "decelerationValue.UntilExpressionCard";
    public static final String DISTANCE_VALUE = "distanceValue.UntilDistanceCard";
    public static final String BLEND_RADIUS = "blendRadius.UntilDistanceCard";
    public static final String STOP_BUTTON = "stopButton.UntilDistanceCard";
    public static final String BLEND_BUTTON = "blendRadiusButton.UntilDistanceCard";
    public static final String USE_CUSTOM_DECELERATION = "useCustomDecelerationButton.UntilExpressionCard";
    public static final String USE_SHARED_DECELERATION = "useSharedDecelerationButton.UntilExpressionCard";
    public static final String UNTIL_DIGITAL_INPUT = "untilDigitalInput.UntilIOCard";
    public static final String DIGITAL_INPUT = "digitalInput.UntilIOCard";
    public static final String DIGITAL_VALUE = "digitalValue.UntilIOCard";
    public static final String UNTIL_ANALOG_INPUT = "untilAnalogInput.UntilIOCard";
    public static final String ANALOG_INPUT = "analogInput.UntilIOCard";
    public static final String ANALOG_COMPARISION = "analogComparision.UntilIOCard";
    public static final String ANALOG_VALUE = "analogValue.UntilIOCard";
    public static final String DEFAULT_DIGITAL_INPUT_NAME = "digital_in";
    public static final String DEFAULT_ANALOG_INPUT_NAME = "analog_in";

    @Inject
    public UntilNodeDriver(MainScreen mainScreen) {
        super(mainScreen, UNTIL_CARD);
    }

    public void addUntil() {
        this.push(this.buttonNamed(ADD_UNTIL));
    }

    public void selectExpression() {
        this.push(this.buttonNamed(UNTIL_EXPRESSION_BUTTON));
    }

    public void selectIO() {
        this.push(this.buttonNamed(UNTIL_IO));
    }

    public void selectReachedWaypoint() {
        this.push(this.buttonNamed(UNTIL_REACHED_WAYPOINT));
    }

    public UntilContactDetectionDriver selectContactDetection() {
        this.push(this.buttonNamed(UNTIL_CONTACT_DETECTION));
        return new UntilContactDetectionDriver(this.mainScreen);
    }

    public void setExpression(String expression) {
        this.waitingUntilShowingTextFieldNamed(EXPRESSION_EDITOR);
        ExpressionPickerOperator operator = new ExpressionPickerOperator((JTextComponentOperator)this.textFieldNamed(EXPRESSION_EDITOR));
        operator.typeFullExpression(expression);
        operator.clickOk();
    }

    public String getDeceleration() {
        this.waitingUntilShowingTextFieldNamed(DECELERATION_VALUE);
        return this.textFieldNamed(DECELERATION_VALUE).getText();
    }

    public void setDeceleration(String deceleration) {
        this.waitingUntilShowingRadioButtonNamed(USE_CUSTOM_DECELERATION);
        this.push((AbstractButtonOperator)this.radioButtonNamed(USE_CUSTOM_DECELERATION));
        this.waitingUntilTextFieldComponentNamed(DECELERATION_VALUE);
        NumberKeyPadOperator operator = new NumberKeyPadOperator(this.textFieldNamed(DECELERATION_VALUE));
        operator.punchInKeypad(deceleration);
    }

    public void setUseSharedDeceleration() {
        this.push((AbstractButtonOperator)this.radioButtonNamed(USE_SHARED_DECELERATION));
    }

    public void setUseCustomDeceleration() {
        this.push((AbstractButtonOperator)this.radioButtonNamed(USE_CUSTOM_DECELERATION));
    }

    public void selectDistance() {
        this.push(this.buttonNamed(UNTIL_DISTANCE_BUTTON));
    }

    public void setDistance(String value) {
        this.waitingUntilShowingTextFieldNamed(DISTANCE_VALUE);
        NumberKeyPadOperator operator = new NumberKeyPadOperator(this.textFieldNamed(DISTANCE_VALUE));
        operator.punchInKeypad(value);
    }

    public void setStopAtThisPoint() {
        this.push(this.buttonNamed(STOP_BUTTON));
    }

    public void setBlendRadius(String value) {
        this.push(this.buttonNamed(BLEND_BUTTON));
        NumberKeyPadOperator operator = new NumberKeyPadOperator(this.textFieldNamed(BLEND_RADIUS));
        operator.punchInKeypad(value);
    }

    public void enableActions() {
        this.push((AbstractButtonOperator)this.checkBoxNamed(ADD_ACTIONS_SWITCH));
    }

    private void waitingUntilShowingTextFieldNamed(final String componentName) {
        Waiting.until((Waiting.ItHappens)new Waiting.ItHappens(){

            public boolean itHappened() {
                return UntilNodeDriver.this.textFieldNamed(componentName).isShowing();
            }
        }, (int)2, (TimeUnit)TimeUnit.SECONDS);
    }

    private void waitingUntilShowingRadioButtonNamed(final String componentName) {
        Waiting.until((Waiting.ItHappens)new Waiting.ItHappens(){

            public boolean itHappened() {
                return UntilNodeDriver.this.radioButtonNamed(componentName).isShowing();
            }
        }, (int)2, (TimeUnit)TimeUnit.SECONDS);
    }

    private void waitingUntilTextFieldComponentNamed(final String componentName) {
        Waiting.until((Waiting.ItHappens)new Waiting.ItHappens(){

            public boolean itHappened() {
                return UntilNodeDriver.this.textFieldNamed(componentName).isEnabled();
            }
        }, (int)2, (TimeUnit)TimeUnit.SECONDS);
    }

    private void selectRadioButton(String name) {
        this.push((AbstractButtonOperator)this.radioButtonNamed(name));
    }

    public void selectDigitalIO() {
        this.selectRadioButton(UNTIL_DIGITAL_INPUT);
    }

    public void setDigitalInputSelection(int pin) {
        this.setComboFromName(DIGITAL_INPUT, "digital_in[" + pin + "]");
    }

    public void setDigitalValue(int value) {
        this.comboBoxNamed(DIGITAL_VALUE).setSelectedIndex(value);
    }

    public void selectAnalogIO() {
        this.selectRadioButton(UNTIL_ANALOG_INPUT);
    }

    public void setAnalogInputSelection(int pin) {
        this.setComboFromName(ANALOG_INPUT, "analog_in[" + pin + "]");
    }

    public void setAnalogComparision(int comboboxIndex) {
        this.comboBoxNamed(ANALOG_COMPARISION).setSelectedIndex(comboboxIndex);
    }

    public void setAnalogValue(int number) {
        this.clearAndType(number, ANALOG_VALUE);
    }

    public void selectDigitalInput(int pin, int value) {
        this.selectDigitalIO();
        this.setDigitalInputSelection(pin);
        this.setDigitalValue(value);
    }

    public void selectAnalogInput(int pin, int comparision, int value) {
        this.selectAnalogIO();
        this.setAnalogInputSelection(pin);
        this.setAnalogComparision(comparision);
        this.setAnalogValue(value);
    }

    private void setComboFromName(String comboBoxName, String itemName) {
        int index = this.comboBoxNamed(comboBoxName).findItemIndex(itemName, Operator.getDefaultStringComparator());
        this.comboBoxNamed(comboBoxName).setSelectedIndex(index);
    }
}

