/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.application.driver.program.operator;

import com.ur.swing.ComponentDriver;
import com.ur.swing.JemmyUtils;
import com.ur.util.Waiting;
import java.awt.Component;
import java.util.concurrent.TimeUnit;
import javax.swing.JButton;
import javax.swing.JTextField;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JComponentOperator;
import org.netbeans.jemmy.operators.JDialogOperator;
import org.netbeans.jemmy.operators.JTextComponentOperator;

public class ExpressionPickerOperator {
    public static final String EXPRESSION_TEXT_FIELD = "expressionTextField.ExpressionEditorPanel";
    public static final String OK_BUTTON = "OK.ExpressionPicker";
    public static final String TEXT_PICKER = "TEXT_PICKER.ExpressionPicker";
    public static final String BACKSPACE_BUTTON = "BACKSPACE.ExpressionPicker";
    private static final int WAIT_AFTER_BUTTON_PRESS = 500;
    private final JDialogOperator expressionPicker;

    public ExpressionPickerOperator(JTextComponentOperator textField) {
        textField.clickMouse();
        Waiting.pause((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
        this.expressionPicker = new JDialogOperator(ComponentDriver.aComponent((String)TEXT_PICKER, (ComponentChooser[])new ComponentChooser[]{ComponentDriver.showing()}));
    }

    public void typeFullExpression(String text) {
        String[] split;
        for (String each : split = text.split(" ")) {
            if (each.length() > 1 && Character.isDigit(each.charAt(0))) {
                for (char integer : each.toCharArray()) {
                    this.clickButtonWith(integer + "");
                }
                continue;
            }
            this.clickButtonWith(each);
        }
    }

    public void type(String text) {
        this.typeFullExpression(text);
        this.clickOk();
    }

    private void clickButtonWithName(String name) {
        JemmyUtils.getButtonByName((Object)this.expressionPicker, (String)name).clickMouse();
        Waiting.pause((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    private void clickButtonWith(final String text) {
        JButtonOperator operator = new JButtonOperator((ContainerOperator)this.expressionPicker, new ComponentChooser(){

            public boolean checkComponent(Component component) {
                return component instanceof JButton && ((JButton)component).getText().equals(text);
            }

            public String getDescription() {
                return text;
            }
        });
        operator.clickMouse();
        Waiting.pause((long)50L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public void clickOk() {
        this.clickButtonWithName(OK_BUTTON);
        Waiting.until((Waiting.ItHappens)this.isNotShowing(), (int)500, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public void clickBackSpace() {
        this.clickButtonWithName(BACKSPACE_BUTTON);
        Waiting.until((Waiting.ItHappens)this.isNotShowing(), (int)500, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public void longPressBackSpace(int timeMillis) {
        JButtonOperator buttonByName = JemmyUtils.getButtonByName((Object)this.expressionPicker, (String)BACKSPACE_BUTTON);
        buttonByName.pressMouse();
        Waiting.pause((long)timeMillis, (TimeUnit)TimeUnit.MILLISECONDS);
        buttonByName.releaseMouse();
        Waiting.pause((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public String getText() {
        JComponentOperator componentByName = JemmyUtils.getComponentByName((Object)this.expressionPicker, (String)EXPRESSION_TEXT_FIELD);
        return ((JTextField)componentByName.getSource()).getText();
    }

    private Waiting.ItHappens isNotShowing() {
        return new Waiting.ItHappens(){

            public boolean itHappened() {
                return !ExpressionPickerOperator.this.expressionPicker.isShowing();
            }
        };
    }
}

