/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.application.driver.security;

import com.ur.polyscope.driver.api.BaseDriver;
import com.ur.polyscope.driver.api.MainScreen;
import com.ur.polyscope.driver.api.NotEnabled;
import com.ur.swing.text.driver.TextPickerOperator;
import com.ur.util.Waiting;
import com.ur.util.logging.Log;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.netbeans.jemmy.TimeoutExpiredException;
import org.netbeans.jemmy.operators.JComponentOperator;
import org.netbeans.jemmy.operators.JPopupMenuOperator;
import org.netbeans.jemmy.operators.JTextComponentOperator;
import org.netbeans.jemmy.operators.JTextFieldOperator;

public class SecurityDriver
extends BaseDriver {
    private static final String SETTINGS_MENU_BUTTON = "settingsScreen.HeaderMenu";
    private static final String HAMBURGER_MENU = "HamburgerMenuButton.HeaderMenu";
    private static final String GENERAL_BUTTON = "generalSettings.action";
    private static final String GENERAL_PANEL = "GeneralSettingsPanel";
    private static final String PASSWORD_BUTTON = "AdminButton.SetupPanel";
    private static final String PASSWORD_PANEL = "PASSWORD";
    private static final String SERVICES_BUTTON = "servicesSettings.action";
    private static final String SERVICES_PANEL = "ServicesSettingsPanel";
    private static final String SSH_BUTTON = "secureShellSettings.action";
    private static final String SSH_PANEL = "SecureShellPanel";
    private static final String PERMISSIONS_BUTTON = "systemPagesPermissions.action";
    private static final String PERMISSIONS_PANEL = "SystemPagesPermissionsView";
    private static final int WAIT_FOR_COMPONENT_TIME = 2;

    @Inject
    protected SecurityDriver(MainScreen mainScreen) {
        super(mainScreen, "");
    }

    public void openSettingsMenu() {
        JPopupMenuOperator hamburgerMenu = this.openHamburgerMenu();
        this.waitForComponentShowing(SETTINGS_MENU_BUTTON);
        this.pushPopupMenuItem(hamburgerMenu, SETTINGS_MENU_BUTTON);
    }

    public void closeSettingsMenu() {
        this.push(this.buttonNamed("ExitButton.G5SettingsTab"));
        this.ensureSettingsNotShowing();
    }

    public void openPasswordMenu() {
        this.openPasswordTab(PASSWORD_BUTTON);
        this.push(this.buttonNamed(PASSWORD_BUTTON));
        this.waitForComponentShowing(PASSWORD_PANEL);
    }

    public void openGeneralMenu() {
        this.openSecurityTabIfNotShowing(GENERAL_BUTTON);
        this.push(this.buttonNamed(GENERAL_BUTTON));
        this.waitForComponentShowing(GENERAL_PANEL);
    }

    public void openServicesMenu() {
        this.openSecurityTabIfNotShowing(SERVICES_BUTTON);
        this.push(this.buttonNamed(SERVICES_BUTTON));
        this.waitForComponentShowing(SERVICES_PANEL);
        this.selectFirstRow();
    }

    public void openSecureShellMenu() {
        this.openSecurityTabIfNotShowing(SSH_BUTTON);
        this.push(this.buttonNamed(SSH_BUTTON));
        this.waitForComponentShowing(SSH_PANEL);
    }

    public void openPermissionsMenu() {
        this.openSecurityTabIfNotShowing(PERMISSIONS_BUTTON);
        this.push(this.buttonNamed(PERMISSIONS_BUTTON));
        this.waitForComponentShowing(PERMISSIONS_PANEL);
    }

    private void selectFirstRow() {
        this.tableNamed("ServicesSettingsPanel.serviceTable").selectCell(0, 0);
    }

    public void unlockSettings(String password) {
        JTextFieldOperator operator = this.textFieldNamed("AdminPasswordFooter.passwordField");
        this.typeAndClickOk(password, (JTextComponentOperator)operator);
    }

    private void typeAndClickOk(String text, JTextComponentOperator forTextComponent) {
        if (!SecurityDriver.waitingFor(this.isEnabled((JComponentOperator)forTextComponent))) {
            throw new NotEnabled("TextComponent named '" + forTextComponent.getName() + "' was not enabled when trying to type '" + text + "'");
        }
        new TextPickerOperator(forTextComponent).type(text);
    }

    public boolean isUnlocked() {
        return SecurityDriver.waitingFor(this.isDisabled((JComponentOperator)this.buttonNamed("AdminPasswordFooter.unlockButton")));
    }

    private void ensureSettingsNotShowing() {
        boolean notShowing = this.waitForComponentNotShowing("SecurityTab.G5SettingsTab");
        if (!notShowing) {
            throw new IllegalStateException("Component 'SecurityTab.G5SettingsTab' was showing");
        }
    }

    private void openPasswordTab(String subMenuComponent) {
        if (!this.quickIsShowing(subMenuComponent)) {
            this.push(this.buttonNamed("PassswordTab.G5SettingsTab"));
        }
    }

    private void openSecurityTabIfNotShowing(String subMenuComponent) {
        if (!this.quickIsShowing(subMenuComponent)) {
            this.push(this.buttonNamed("SecurityTab.G5SettingsTab"));
        }
    }

    private JPopupMenuOperator openHamburgerMenu() {
        this.waitForComponentShowing(HAMBURGER_MENU);
        this.buttonNamed(HAMBURGER_MENU).push();
        try {
            return this.popupMenuNamed("HamburgerMenuButton.HeaderMenu.popup");
        }
        catch (TimeoutExpiredException e) {
            Log.error((String)"Timed out waiting for hamburger menu", (Throwable)e);
            return null;
        }
    }

    private boolean waitForComponentNotShowing(String componentName) {
        return SecurityDriver.waitingFor(() -> this.isNotShowing(componentName));
    }

    private boolean waitForComponentShowing(String componentName) {
        return SecurityDriver.waitingFor(() -> this.isShowing(componentName));
    }

    private static boolean waitingFor(Waiting.ItHappens condition) {
        return Waiting.until((Waiting.ItHappens)condition, (int)2, (TimeUnit)TimeUnit.SECONDS);
    }
}

