/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.application.driver.settings;

import com.ur.lang.StringUtils;
import com.ur.polyscope.driver.api.BaseDriver;
import com.ur.polyscope.driver.api.MainScreen;
import com.ur.polyscope.security.PasswordManager;
import com.ur.polyscope.security.PasswordUpdateListener;
import com.ur.swing.DisplayMessageFactory;
import com.ur.swing.text.driver.TextPickerOperator;
import com.ur.util.Waiting;
import com.ur.util.event.EventNotificationService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.jemmy.operators.JComponentOperator;
import org.netbeans.jemmy.operators.JTextComponentOperator;
import org.netbeans.jemmy.operators.JTextFieldOperator;

public class PasswordDriver
extends BaseDriver {
    private static final String LENGTH_REQUIREMENT = "at least 8 characters in length";
    private static final Object BALLOON_MESSAGE = DisplayMessageFactory.class;
    private final String currentPassword;
    private final String newPassword;
    private final String confirmNewPassword;
    private final String applyNewPassword;
    private final String clearPassword;
    private final AtomicBoolean passwordChanged = new AtomicBoolean(false);

    protected PasswordDriver(String panelName, MainScreen mainScreen) {
        super(mainScreen, "");
        this.currentPassword = "current." + panelName;
        this.newPassword = "new." + panelName;
        this.confirmNewPassword = "confirm.new." + panelName;
        this.applyNewPassword = "apply.new." + panelName;
        this.clearPassword = "clear." + panelName;
    }

    public void enterCurrentPassword(String password) {
        this.enterPassword(this.currentPassword, password);
    }

    public void enterNewPassword(String password) {
        this.enterPassword(this.newPassword, password);
    }

    public void enterConfirmedPassword(String password) {
        this.enterPassword(this.confirmNewPassword, password);
    }

    private void enterPassword(String fieldName, String password) {
        new TextPickerOperator((JTextComponentOperator)this.textFieldNamed(fieldName)).type(password);
    }

    public void applyNewPassword() {
        EventNotificationService.register((Object)((Object)this), PasswordUpdateListener.class, e -> this.passwordChanged.set(e == PasswordManager.Lock.ADMIN));
        this.push(this.buttonNamed(this.applyNewPassword));
    }

    public boolean isPasswordChanged() {
        try {
            boolean bl = Waiting.until(this.passwordChanged::get, (int)2, (TimeUnit)TimeUnit.SECONDS);
            return bl;
        }
        finally {
            EventNotificationService.unregister((Object)((Object)this));
        }
    }

    public void clearPassword() {
        this.push(this.buttonNamed(this.clearPassword));
    }

    public boolean passwordNotStrongEnoughMessage() {
        JTextFieldOperator operator = this.textFieldNamed(this.newPassword);
        return Waiting.until(() -> StringUtils.containsWord((String)this.getMessage((JComponentOperator)operator), (String)LENGTH_REQUIREMENT), (int)2, (TimeUnit)TimeUnit.SECONDS);
    }

    public String getMessage(JComponentOperator operator) {
        return (String)operator.getClientProperty(BALLOON_MESSAGE);
    }
}

