/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.application.driver.settings;

import com.ur.polyscope.application.driver.settings.PasswordDriver;
import com.ur.polyscope.driver.api.BaseDriver;
import com.ur.polyscope.driver.api.MainScreen;
import com.ur.util.Waiting;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.netbeans.jemmy.operators.JPopupMenuOperator;

public class SettingsDriver
extends BaseDriver {
    private static final int WAIT_TIME_IN_SECONDS = 2;
    private static final String HAMBURGER_MENU = "HamburgerMenuButton.HeaderMenu";
    private static final String SETTINGS_MENU_BUTTON = "settingsScreen.HeaderMenu";

    @Inject
    protected SettingsDriver(MainScreen mainScreen) {
        super(mainScreen, "");
    }

    public SettingsDriver openSettings() {
        JPopupMenuOperator hamburgerMenu = this.openHamburgerMenu();
        this.waitForComponentShowing(SETTINGS_MENU_BUTTON);
        this.pushPopupMenuItem(hamburgerMenu, SETTINGS_MENU_BUTTON);
        return this;
    }

    private JPopupMenuOperator openHamburgerMenu() {
        this.waitForComponentShowing(HAMBURGER_MENU);
        this.buttonNamed(HAMBURGER_MENU).push();
        return this.popupMenuNamed("HamburgerMenuButton.HeaderMenu.popup");
    }

    public PasswordDriver expandPasswordSection() {
        this.push(this.buttonNamed("PassswordTab.G5SettingsTab"));
        return new PasswordDriver("admin.password", this.mainScreen);
    }

    private void waitForComponentShowing(String componentName) {
        Waiting.until(() -> this.isShowing(componentName), (int)2, (TimeUnit)TimeUnit.SECONDS);
    }

    public void closeSettingsMenu() {
        this.push(this.buttonNamed("ExitButton.G5SettingsTab"));
        this.ensureSettingsNotShowing();
    }

    public boolean isVisible() {
        return this.isShowing("ExitButton.G5SettingsTab");
    }

    private void ensureSettingsNotShowing() {
        boolean notShowing = Waiting.until(() -> this.isNotShowing("SecurityTab.G5SettingsTab"), (int)2, (TimeUnit)TimeUnit.SECONDS);
        if (!notShowing) {
            throw new IllegalStateException("Component 'SecurityTab.G5SettingsTab' was showing");
        }
    }
}

