/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.application.driver.tcp;

import com.ur.polyscope.driver.api.BaseDriver;
import com.ur.polyscope.driver.api.MainScreen;
import com.ur.swing.number.driver.NumberKeyPadOperator;
import com.ur.util.Waiting;
import com.ur.util.logging.Log;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.netbeans.jemmy.operators.JCheckBoxOperator;
import org.netbeans.jemmy.operators.JTextFieldOperator;

public class OptionalPayloadDriver
extends BaseDriver {
    public static final String USE_PAYLOAD = "TotalPayload.usePayload";
    public static final String PAYLOAD_VALUE = "TotalPayload.payloadValue";
    private static JFrame frame;

    public static OptionalPayloadDriver get(final JComponent component) {
        if (frame != null) {
            throw new AlreadyRunningException();
        }
        frame = new JFrame();
        frame.add(component);
        frame.setSize(250, 100);
        frame.setName("urgui.URGUI");
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
        Waiting.until((Waiting.ItHappens)new Waiting.ItHappens(){

            public boolean itHappened() {
                return component.isVisible();
            }
        }, (int)5, (TimeUnit)TimeUnit.SECONDS);
        return new OptionalPayloadDriver(new MainScreen(null){});
    }

    public static void wrapUp() {
        try {
            if (frame == null) {
                return;
            }
            frame.setVisible(false);
            frame.dispose();
            Waiting.until((Waiting.ItHappens)new Waiting.ItHappens(){

                public boolean itHappened() {
                    return !frame.isDisplayable();
                }
            }, (int)30, (TimeUnit)TimeUnit.SECONDS);
            frame = null;
        }
        catch (Exception e) {
            Log.error((String)"Failed to dispose frame", (Throwable)e);
        }
    }

    @Inject
    OptionalPayloadDriver(MainScreen mainScreen) {
        super(mainScreen, USE_PAYLOAD);
    }

    public void disablePayload() {
        JCheckBoxOperator checkBoxOperator = this.usePayload();
        checkBoxOperator.pushNoBlock();
        Waiting.until((Waiting.ItHappens)new Waiting.ItHappens(){

            public boolean itHappened() {
                return !OptionalPayloadDriver.this.isPayloadEnabled();
            }
        }, (int)20, (TimeUnit)TimeUnit.SECONDS);
    }

    public void enablePayload() {
        JCheckBoxOperator checkBoxOperator = this.usePayload();
        checkBoxOperator.pushNoBlock();
        Waiting.until((Waiting.ItHappens)new Waiting.ItHappens(){

            public boolean itHappened() {
                return OptionalPayloadDriver.this.isPayloadEnabled();
            }
        }, (int)20, (TimeUnit)TimeUnit.SECONDS);
    }

    public boolean isPayloadEnabled() {
        return this.usePayload().isSelected();
    }

    public void setPayloadValue(final String valueInKgs) {
        new NumberKeyPadOperator(this.payloadValue()).punchInKeypad(valueInKgs);
        Waiting.until((Waiting.ItHappens)new Waiting.ItHappens(){

            public boolean itHappened() {
                return OptionalPayloadDriver.this.payloadValue().getText().contains(valueInKgs);
            }
        }, (int)20, (TimeUnit)TimeUnit.SECONDS);
    }

    private JTextFieldOperator payloadValue() {
        return this.textFieldNamed(PAYLOAD_VALUE);
    }

    private JCheckBoxOperator usePayload() {
        return this.checkBoxNamed(USE_PAYLOAD);
    }

    private static class AlreadyRunningException
    extends RuntimeException {
        private AlreadyRunningException() {
        }
    }
}

