/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.urcaps;

import com.ur.lang.StringUtils;
import com.ur.polyscope.urcaps.TextResource;
import com.ur.polyscope.urcaps.URCapZipInfo;
import com.ur.polyscope.urcaps.URServiceClient;
import com.ur.util.URLUtils;
import com.ur.util.logging.Log;
import com.ur.util.swing.HTML;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Dictionary;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.osgi.framework.Bundle;

@Singleton
public class BundleUtils {
    private static final String BUNDLE_LICENSE = "Bundle-LicenseType";
    public static final String OSGI_BUNDLE = "osgiBundle";
    private static final String NEWLINE = HTML.br();
    private final TextResource textResource;
    private static URServiceClient urServiceClient;

    @Inject
    public BundleUtils(TextResource textResource) {
        this.textResource = textResource;
    }

    public static void setURServiceClient(URServiceClient client) {
        urServiceClient = client;
    }

    public String buildMetaInfo(Bundle bundle) {
        return this.buildMetaInfo(bundle, EnumSet.allOf(BundleMetaField.class));
    }

    public Map<String, String> buildMetaInfoMap(Bundle bundle, EnumSet<BundleMetaField> includeFields) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (BundleUtils.isZipInstalledBundle(bundle)) {
            URCapZipInfo zipInfo = this.getURCapZipInfo(bundle);
            BundleUtils.putZipInfoInMap(map, this.textResource.urcapName(), zipInfo.getName(), includeFields.contains((Object)BundleMetaField.NAME));
            BundleUtils.putZipInfoInMap(map, this.textResource.urcapVersion(), zipInfo.getVersion(), includeFields.contains((Object)BundleMetaField.VERSION));
            BundleUtils.putZipInfoInMap(map, this.textResource.Developer(), zipInfo.getVendorName(), includeFields.contains((Object)BundleMetaField.DEVELOPER));
            BundleUtils.putZipInfoInMap(map, this.textResource.urcapContactinfo(), zipInfo.getContactInfo(), includeFields.contains((Object)BundleMetaField.CONTACT_INFO));
            BundleUtils.putZipInfoInMap(map, this.textResource.urcapDescription(), zipInfo.getDescription(), includeFields.contains((Object)BundleMetaField.DESCRIPTION));
            BundleUtils.putZipInfoInMap(map, this.textResource.urcapCopyright(), zipInfo.getCopyRight(), includeFields.contains((Object)BundleMetaField.COPYRIGHT));
            BundleUtils.putZipInfoInMap(map, this.textResource.urcapLicensetype(), zipInfo.getLicenseType(), includeFields.contains((Object)BundleMetaField.LICENSE_TYPE));
        } else {
            Dictionary headers = bundle.getHeaders();
            BundleUtils.putInMap(map, headers, this.textResource.urcapName(), "Bundle-Name", includeFields.contains((Object)BundleMetaField.NAME));
            BundleUtils.putInMap(map, headers, this.textResource.urcapVersion(), "Bundle-Version", includeFields.contains((Object)BundleMetaField.VERSION));
            BundleUtils.putInMap(map, headers, this.textResource.Developer(), "Bundle-Vendor", includeFields.contains((Object)BundleMetaField.DEVELOPER));
            BundleUtils.putInMap(map, headers, this.textResource.urcapContactinfo(), "Bundle-ContactAddress", includeFields.contains((Object)BundleMetaField.CONTACT_INFO));
            BundleUtils.putInMap(map, headers, this.textResource.urcapDescription(), "Bundle-Description", includeFields.contains((Object)BundleMetaField.DESCRIPTION));
            BundleUtils.putInMap(map, headers, this.textResource.urcapCopyright(), "Bundle-Copyright", includeFields.contains((Object)BundleMetaField.COPYRIGHT));
            BundleUtils.putInMap(map, headers, this.textResource.urcapLicensetype(), BUNDLE_LICENSE, includeFields.contains((Object)BundleMetaField.LICENSE_TYPE));
        }
        return map;
    }

    private static void putInMap(HashMap<String, String> map, Dictionary<String, String> headers, String label, String key, boolean include) {
        if (include) {
            BundleUtils.putInMap(map, label, headers.get(key));
        }
    }

    private static void putZipInfoInMap(HashMap<String, String> map, String label, String value, boolean include) {
        if (include) {
            BundleUtils.putInMap(map, label, value);
        }
    }

    private static void putInMap(HashMap<String, String> map, String label, String value) {
        map.put(label + ":", StringUtils.ensureEmptyString((String)value));
    }

    public String buildMetaInfo(Bundle bundle, EnumSet<BundleMetaField> includeFields) {
        String license;
        StringBuilder sb = new StringBuilder();
        if (BundleUtils.isZipInstalledBundle(bundle)) {
            this.buildZipMetaInfo(includeFields, this.getURCapZipInfo(bundle), sb);
        } else {
            Dictionary headers = bundle.getHeaders();
            this.buildMetaInfo(includeFields, headers, sb);
        }
        if (includeFields.contains((Object)BundleMetaField.LICENSE) && (license = BundleUtils.readFileFromBundle(bundle)) != null) {
            BundleUtils.appendInfo(sb, this.textResource.urcapLicense(), NEWLINE + license);
        }
        return sb.toString();
    }

    public URCapZipInfo getURCapZipInfo(Bundle bundle) {
        return urServiceClient.getURCapIdentificationFromArtifact(OSGI_BUNDLE, BundleUtils.getBundleLocation(bundle));
    }

    public static boolean isZipInstalledBundle(Bundle bundle) {
        String bundleLocation = BundleUtils.getBundleLocation(bundle);
        try {
            File bundleFile = new File(bundleLocation);
            return "zip".equalsIgnoreCase(bundleFile.getParentFile().getName());
        }
        catch (Exception e) {
            Log.error((String)"Unable to get bundle location", (Throwable)e);
            return false;
        }
    }

    private static String getBundleLocation(Bundle bundle) {
        String location = bundle.getLocation();
        location = BundleUtils.removeFirst(location, "reference:");
        location = BundleUtils.removeFirst(location, "file:");
        return location;
    }

    private static String removeFirst(String location, String remove) {
        if (location.startsWith(remove)) {
            Log.info((String)("Removing '" + remove + "' from bundle location : " + location));
            return location.replaceFirst(remove, "");
        }
        return location;
    }

    public void buildMetaInfo(EnumSet<BundleMetaField> includeFields, Dictionary<String, String> headers, StringBuilder sb) {
        BundleUtils.appendInfo(sb, headers, this.textResource.urcapName(), "Bundle-Name", includeFields.contains((Object)BundleMetaField.NAME));
        BundleUtils.appendInfo(sb, headers, this.textResource.urcapVersion(), "Bundle-Version", includeFields.contains((Object)BundleMetaField.VERSION));
        BundleUtils.appendInfo(sb, headers, this.textResource.Developer(), "Bundle-Vendor", includeFields.contains((Object)BundleMetaField.DEVELOPER));
        BundleUtils.appendInfo(sb, headers, this.textResource.urcapContactinfo(), "Bundle-ContactAddress", includeFields.contains((Object)BundleMetaField.CONTACT_INFO));
        BundleUtils.appendInfo(sb, headers, this.textResource.urcapDescription(), "Bundle-Description", includeFields.contains((Object)BundleMetaField.DESCRIPTION));
        BundleUtils.appendInfo(sb, headers, this.textResource.urcapCopyright(), "Bundle-Copyright", includeFields.contains((Object)BundleMetaField.COPYRIGHT));
        BundleUtils.appendInfo(sb, headers, this.textResource.urcapLicensetype(), BUNDLE_LICENSE, includeFields.contains((Object)BundleMetaField.LICENSE_TYPE));
    }

    public StringBuilder buildZipMetaInfo(EnumSet<BundleMetaField> includeFields, URCapZipInfo urCapZipInfo, StringBuilder sb) {
        BundleUtils.appendZipInfo(sb, this.textResource.urcapName(), urCapZipInfo.getName(), includeFields.contains((Object)BundleMetaField.NAME));
        BundleUtils.appendZipInfo(sb, this.textResource.urcapVersion(), urCapZipInfo.getVersion(), includeFields.contains((Object)BundleMetaField.VERSION));
        BundleUtils.appendZipInfo(sb, this.textResource.Developer(), urCapZipInfo.getVendorName(), includeFields.contains((Object)BundleMetaField.DEVELOPER));
        BundleUtils.appendZipInfo(sb, this.textResource.urcapContactinfo(), urCapZipInfo.getContactInfo(), includeFields.contains((Object)BundleMetaField.CONTACT_INFO));
        BundleUtils.appendZipInfo(sb, this.textResource.urcapDescription(), urCapZipInfo.getDescription(), includeFields.contains((Object)BundleMetaField.DESCRIPTION));
        BundleUtils.appendZipInfo(sb, this.textResource.urcapCopyright(), urCapZipInfo.getCopyRight(), includeFields.contains((Object)BundleMetaField.COPYRIGHT));
        BundleUtils.appendZipInfo(sb, this.textResource.urcapLicensetype(), urCapZipInfo.getLicenseType(), includeFields.contains((Object)BundleMetaField.LICENSE_TYPE));
        return sb;
    }

    private static void appendInfo(StringBuilder sb, Dictionary<String, String> headers, String label, String key, boolean include) {
        if (include) {
            BundleUtils.appendInfo(sb, label, headers.get(key));
        }
    }

    private static void appendZipInfo(StringBuilder sb, String label, String value, boolean include) {
        if (include) {
            BundleUtils.appendInfo(sb, label, value);
        }
    }

    private static void appendInfo(StringBuilder sb, String label, String value) {
        if (value != null) {
            sb.append(HTML.fontBold((String)label)).append(": ").append(value).append(NEWLINE);
        }
    }

    private static String readFileFromBundle(Bundle bundle) {
        URL url = bundle.getResource("META-INF/LICENSE");
        if (url != null) {
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
                StringBuilder sb = new StringBuilder();
                while (br.ready()) {
                    sb.append(br.readLine()).append(NEWLINE);
                }
                return sb.toString();
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    public static void extractFromBundle(Bundle bundle, URL sourceUrl) {
        try {
            File destinationDir = bundle.getDataFile("");
            Enumeration entries = bundle.findEntries(URLUtils.getPath((URL)sourceUrl), "*", true);
            while (entries != null && entries.hasMoreElements()) {
                URL url = (URL)entries.nextElement();
                String urlPath = URLUtils.getPath((URL)url);
                File dest = new File(destinationDir, urlPath);
                if (urlPath.endsWith("/")) {
                    dest.mkdirs();
                    continue;
                }
                InputStream is = bundle.getEntry(urlPath).openStream();
                FileUtils.copyInputStreamToFile((InputStream)is, (File)dest);
                is.close();
                dest.setExecutable(true);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String getBundleAttribute(Bundle bundle, String attribute) {
        Dictionary headers;
        String value = "";
        if (bundle != null && (value = (String)(headers = bundle.getHeaders()).get(attribute)) == null) {
            value = "";
        }
        return value;
    }

    public String getUrcapName(Bundle bundle) {
        if (BundleUtils.isZipInstalledBundle(bundle)) {
            URCapZipInfo urCapZipInfo = this.getURCapZipInfo(bundle);
            if (urCapZipInfo != null) {
                return urCapZipInfo.getName();
            }
            Log.error((String)"Unable to obtain URCap Information");
        }
        return (String)bundle.getHeaders().get("Bundle-Name");
    }

    public static enum BundleMetaField {
        NAME,
        VERSION,
        DEVELOPER,
        CONTACT_INFO,
        DESCRIPTION,
        COPYRIGHT,
        LICENSE_TYPE,
        LICENSE;

    }
}

