/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.urcaps.contributions;

import com.ur.polyscope.java.logger.LogFactory;
import com.ur.polyscope.java.logger.Logger;
import com.ur.polyscope.urcaps.contributions.URCap;
import com.ur.polyscope.urcaps.contributions.URCapComparator;
import com.ur.polyscope.urcaps.contributions.URCapProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ContributionSet {
    private static final Logger LOG = LogFactory.createLogger(ContributionSet.class);
    private final List<URCap> contributions = new ArrayList<URCap>();
    private final Set<URCapProvider> providers = new HashSet<URCapProvider>();

    @Inject
    public ContributionSet() {
        this(new HashSet<URCapProvider>());
    }

    public ContributionSet(Set<URCapProvider> providers) {
        this.providers.addAll(providers);
    }

    public void addProvider(URCapProvider provider) {
        if (!this.contributions.isEmpty()) {
            LOG.fatal("URCap contributions may not work correctly, as the %s was added too late.", new Object[]{provider.getClass()});
        }
        this.providers.add(provider);
    }

    public Collection<URCap> getContributions() {
        if (this.contributions.isEmpty()) {
            this.updateContributions();
        }
        return Collections.unmodifiableCollection(this.contributions);
    }

    private void updateContributions() {
        this.contributions.clear();
        for (URCapProvider each : this.providers) {
            this.contributions.addAll(each.getURCaps());
        }
        ContributionSet.updateURCapsWithOwnerId(this.contributions);
        ContributionSet.sortURCaps(this.contributions);
    }

    private static void updateURCapsWithOwnerId(List<URCap> contributions) {
        for (URCap each : contributions) {
            each.getURCapInformation().setOwnerId(each.getURCapInformation().getSymbolicName());
        }
    }

    private static void sortURCaps(List<URCap> contributions) {
        Collections.sort(contributions, new URCapComparator());
    }
}

