/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.urcaps.contributions;

import com.ur.lang.EqualsUtil;
import com.ur.lang.StringUtils;
import com.ur.urcap.api.domain.URCapInfo;
import com.ur.util.CollectionUtils;
import com.ur.util.Predicate;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class URCapInformation
implements URCapInfo {
    private final HashMap<String, String> headers = new HashMap();
    public static final String NAME = "name";
    public static final String INSTALLATION_CONTRIBUTION_TITLE = "installationContributionTitle";
    public static final String VENDOR = "vendor";
    public static final String BUNDLE_SYMBOLIC_NAME = "Bundle-SymbolicName";
    public static final String BUNDLE_VERSION = "Bundle-Version";
    public static final String OWNER_ID = "ownerId";

    public URCapInformation(Map<String, String> headers) {
        this.headers.putAll(headers);
    }

    public URCapInformation(String ownerId, String installationContributionTitle, String name, String vendor) {
        this.setAttribute(OWNER_ID, ownerId);
        this.setAttribute(INSTALLATION_CONTRIBUTION_TITLE, installationContributionTitle);
        this.setAttribute(NAME, name);
        this.setAttribute(VENDOR, vendor);
    }

    public boolean hasHeaders() {
        return !CollectionUtils.filter(this.headers.values(), (Predicate)new FilterEmptyOrNullStrings()).isEmpty();
    }

    @Deprecated
    public void setOwnerId(String ownerId) {
        this.setAttribute(OWNER_ID, ownerId);
    }

    @Deprecated
    public void setInstallationContributionTitle(String installationContributionTitle) {
        this.setAttribute(INSTALLATION_CONTRIBUTION_TITLE, StringUtils.ensureEmptyString((String)installationContributionTitle));
    }

    public String getInstallationContributionTitle() {
        return this.getBundleAttribute(INSTALLATION_CONTRIBUTION_TITLE, BUNDLE_SYMBOLIC_NAME);
    }

    public String getSymbolicName() {
        return this.getBundleAttribute(BUNDLE_SYMBOLIC_NAME);
    }

    public String getOwnerId() {
        return this.getBundleAttribute(OWNER_ID);
    }

    public String getCategory() {
        return this.getBundleAttribute("Bundle-Category");
    }

    @Deprecated
    public void setName(String name) {
        this.setAttribute(NAME, name);
    }

    public String getName() {
        return this.getBundleAttribute("Bundle-Name", NAME);
    }

    @Deprecated
    public void setVendor(String vendor) {
        this.setAttribute(VENDOR, vendor);
    }

    public String getVendor() {
        return this.getBundleAttribute("Bundle-Vendor", VENDOR);
    }

    public String getVersion() {
        return this.getBundleAttribute(BUNDLE_VERSION);
    }

    public boolean isThirdParty() {
        String category = this.getCategory();
        return category == null ? false : category.toLowerCase(Locale.ENGLISH).contains("urcap");
    }

    private String getBundleAttribute(String firstKey, String secondKey) {
        if (this.headers.get(firstKey) != null) {
            return this.headers.get(firstKey);
        }
        return this.getBundleAttribute(secondKey);
    }

    public String getBundleAttribute(String attribute) {
        return this.headers.get(attribute) == null ? "" : this.headers.get(attribute);
    }

    private void setAttribute(String name, String value) {
        if (!StringUtils.isNullOrOnlyWhitespace((String)value) || this.headers.get(name) == null) {
            this.headers.put(name, value);
        }
    }

    public int hashCode() {
        return 31 + this.headers.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !URCapInformation.class.equals(obj.getClass())) {
            return false;
        }
        URCapInformation other = (URCapInformation)obj;
        return this.equals(other);
    }

    public boolean equals(URCapInformation other) {
        return EqualsUtil.equals(this.headers, other.headers);
    }

    public String reportToString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.info("URCap Name", "Bundle-Name")).append(this.info("URCap Version", BUNDLE_VERSION)).append(this.info("Developer", "Bundle-Vendor")).append(this.info("Contact Info", "Bundle-ContactAddress")).append(this.info("Description", "Bundle-Description")).append(this.info("Copyright", "Bundle-Copyright")).append(this.info("Licese Type", "Bundle-LicenseType"));
        return stringBuilder.toString();
    }

    private String info(String label, String key) {
        String value = this.headers.get(key);
        return String.format("%s: %s%n", label, value);
    }

    private static class FilterEmptyOrNullStrings
    implements Predicate<String> {
        private FilterEmptyOrNullStrings() {
        }

        public boolean test(String o) {
            return !StringUtils.isNullOrOnlyWhitespace((String)o);
        }
    }
}

