/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.urcaps.contributions.compatibility;

import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class Version {
    private final int major;
    private final int minor;
    private final int patch;

    public Version(String version) {
        if (version == null) {
            this.major = 0;
            this.minor = 0;
            this.patch = 0;
        } else {
            String[] split = version.split("\\.");
            this.major = Version.parseInt(split[0]);
            this.minor = Version.parseInt(split[1]);
            this.patch = Version.parseInt(split[2]);
        }
    }

    public Version(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public boolean isGreaterThen(Version other) {
        if (this.major > other.major) {
            return true;
        }
        if (this.major == other.major && this.minor > other.minor) {
            return true;
        }
        return this.major == other.major && this.minor == other.minor && this.patch > other.patch;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        if (this.getMajor() != version.getMajor()) {
            return false;
        }
        if (this.getMinor() != version.getMinor()) {
            return false;
        }
        return this.getPatch() == version.getPatch();
    }

    public int hashCode() {
        int result = this.getMajor();
        result = 31 * result + this.getMinor();
        result = 31 * result + this.getPatch();
        return result;
    }

    public String toString() {
        return "" + this.major + "." + this.minor + "." + this.patch;
    }

    private static int parseInt(String s) {
        if (s.contains("-")) {
            s = s.substring(0, s.indexOf(45));
        }
        return Integer.parseInt(s);
    }
}

