/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.urcaps.domain.value;

import com.ur.polyscope.valueobjects.NumberValue;
import com.ur.urcap.api.domain.value.Range;

public class RangeImpl<T extends NumberValue<?>>
implements Range<T> {
    private final T lower;
    private final T upper;

    public RangeImpl(T lower, T upper) {
        this.lower = lower;
        this.upper = upper;
    }

    public T getLowerBound() {
        return this.lower;
    }

    public T getUpperBound() {
        return this.upper;
    }

    public boolean isWithinRange(T value) {
        double valueAsDouble = value.asDouble();
        return this.lower.asDouble() <= valueAsDouble && valueAsDouble <= this.upper.asDouble();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RangeImpl range = (RangeImpl)o;
        if (this.lower != null ? !this.lower.equals(range.lower) : range.lower != null) {
            return false;
        }
        return this.upper != null ? this.upper.equals(range.upper) : range.upper == null;
    }

    public int hashCode() {
        int result = this.lower != null ? this.lower.hashCode() : 0;
        result = 31 * result + (this.upper != null ? this.upper.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Range[" + this.lower + "..." + this.upper + ']';
    }
}

