/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.urcaps.domain.value;

import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.urcaps.domain.DataModelReader;
import com.ur.polyscope.urcaps.domain.Pair;
import com.ur.polyscope.urcaps.domain.ValueParser;
import com.ur.polyscope.urcaps.domain.value.AccelerationImpl;
import com.ur.polyscope.urcaps.domain.value.AngleImpl;
import com.ur.polyscope.urcaps.domain.value.AngularAccelerationImpl;
import com.ur.polyscope.urcaps.domain.value.AngularSpeedImpl;
import com.ur.polyscope.urcaps.domain.value.CurrentImpl;
import com.ur.polyscope.urcaps.domain.value.ForceImpl;
import com.ur.polyscope.urcaps.domain.value.LengthImpl;
import com.ur.polyscope.urcaps.domain.value.PressureImpl;
import com.ur.polyscope.urcaps.domain.value.SpeedImpl;
import com.ur.polyscope.urcaps.domain.value.TimeImpl;
import com.ur.polyscope.urcaps.domain.value.TorqueImpl;
import com.ur.polyscope.urcaps.domain.value.VoltageImpl;
import com.ur.polyscope.urcaps.jointposition.JointPositionUtil;
import com.ur.urcap.api.domain.value.PoseFactory;
import com.ur.urcap.api.domain.value.PositionFactory;
import com.ur.urcap.api.domain.value.RotationFactory;
import com.ur.urcap.api.domain.value.ValueFactoryProvider;
import com.ur.urcap.api.domain.value.blend.BlendFactory;
import com.ur.urcap.api.domain.value.expression.ExpressionBuilder;
import com.ur.urcap.api.domain.value.jointposition.JointPositionFactory;
import com.ur.urcap.api.domain.value.simple.SimpleValueFactory;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class ValueFactoryProviderImpl
implements ValueFactoryProvider,
DataModelReader {
    private final PoseFactory poseFactory;
    private final Set<ValueParser> parserSet;
    private final SimpleValueFactory valueFactory;
    private final Provider<ExpressionBuilder> expressionBuilderProvider;
    private final BlendFactory blendFactory;
    private static PositionFactory positionFactory;
    private static RotationFactory rotationFactory;
    private final JointPositionFactory jointPositionFactory;

    @Inject
    public ValueFactoryProviderImpl(SimpleValueFactory valueFactory, Provider<ExpressionBuilder> expressionBuilderProvider, BlendFactory blendFactory, JointPositionFactory jointPositionFactory, PoseFactory poseFactory, Set<ValueParser> parserSet) {
        this.valueFactory = valueFactory;
        this.expressionBuilderProvider = expressionBuilderProvider;
        this.blendFactory = blendFactory;
        this.jointPositionFactory = JointPositionUtil.getFactory();
        this.poseFactory = poseFactory;
        this.parserSet = parserSet;
    }

    @Inject
    public static void setPositionFactory(PositionFactory factory) {
        positionFactory = factory;
    }

    @Inject
    public static void setRotationFactory(RotationFactory factory) {
        rotationFactory = factory;
    }

    @Override
    public boolean canRead(String nodeName) {
        for (ValueParser each : this.parserSet) {
            if (!each.canRead(nodeName)) continue;
            return true;
        }
        return AccelerationImpl.canRead(nodeName) || AngleImpl.canRead(nodeName) || AngularAccelerationImpl.canRead(nodeName) || AngularSpeedImpl.canRead(nodeName) || CurrentImpl.canRead(nodeName) || ForceImpl.canRead(nodeName) || LengthImpl.canRead(nodeName) || SpeedImpl.canRead(nodeName) || TimeImpl.canRead(nodeName) || TorqueImpl.canRead(nodeName) || VoltageImpl.canRead(nodeName) || PressureImpl.canRead(nodeName);
    }

    @Override
    public Pair<String, Object> readKeyValue(String nodeName, PersistReader reader) {
        if (AccelerationImpl.canRead(nodeName)) {
            return new Pair<String, Object>(AccelerationImpl.readKey(reader), AccelerationImpl.readValue(reader));
        }
        if (AngleImpl.canRead(nodeName)) {
            return new Pair<String, Object>(AngleImpl.readKey(reader), AngleImpl.readValue(reader));
        }
        if (AngularAccelerationImpl.canRead(nodeName)) {
            return new Pair<String, Object>(AngularAccelerationImpl.readKey(reader), AngularAccelerationImpl.readValue(reader));
        }
        if (AngularSpeedImpl.canRead(nodeName)) {
            return new Pair<String, Object>(AngularSpeedImpl.readKey(reader), AngularSpeedImpl.readValue(reader));
        }
        if (CurrentImpl.canRead(nodeName)) {
            return new Pair<String, Object>(CurrentImpl.readKey(reader), CurrentImpl.readValue(reader));
        }
        if (ForceImpl.canRead(nodeName)) {
            return new Pair<String, Object>(ForceImpl.readKey(reader), ForceImpl.readValue(reader));
        }
        if (LengthImpl.canRead(nodeName)) {
            return new Pair<String, Object>(LengthImpl.readKey(reader), LengthImpl.readValue(reader));
        }
        if (SpeedImpl.canRead(nodeName)) {
            return new Pair<String, Object>(SpeedImpl.readKey(reader), SpeedImpl.readValue(reader));
        }
        if (TimeImpl.canRead(nodeName)) {
            return new Pair<String, Object>(TimeImpl.readKey(reader), TimeImpl.readValue(reader));
        }
        if (TorqueImpl.canRead(nodeName)) {
            return new Pair<String, Object>(TorqueImpl.readKey(reader), TorqueImpl.readValue(reader));
        }
        if (VoltageImpl.canRead(nodeName)) {
            return new Pair<String, Object>(VoltageImpl.readKey(reader), VoltageImpl.readValue(reader));
        }
        if (PressureImpl.canRead(nodeName)) {
            return new Pair<String, Object>(PressureImpl.readKey(reader), PressureImpl.readValue(reader));
        }
        for (ValueParser each : this.parserSet) {
            if (!each.canRead(nodeName)) continue;
            return new Pair<String, Object>(each.readKey(reader), each.readValue(reader));
        }
        return null;
    }

    public PoseFactory getPoseFactory() {
        return this.poseFactory;
    }

    public SimpleValueFactory getSimpleValueFactory() {
        return this.valueFactory;
    }

    public ExpressionBuilder createExpressionBuilder() {
        return (ExpressionBuilder)this.expressionBuilderProvider.get();
    }

    public BlendFactory getBlendFactory() {
        return this.blendFactory;
    }

    public JointPositionFactory getJointPositionFactory() {
        return this.jointPositionFactory;
    }

    public PositionFactory getPositionFactory() {
        return positionFactory;
    }

    public RotationFactory getRotationFactory() {
        return rotationFactory;
    }
}

