/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.urcaps.exception;

public class ProxiedException
extends RuntimeException {
    private RuntimeException orgException;
    private Class throwingClass;
    private final String fullyQualifiedCatchingClassName;
    private final String catchingMethodName;

    public ProxiedException(RuntimeException orgException, Class<?> throwingClass, String fullyQualifiedCatchingClassName, String catchingMethodName) {
        super(orgException.getMessage(), orgException.getCause());
        this.orgException = orgException;
        this.throwingClass = throwingClass;
        this.fullyQualifiedCatchingClassName = fullyQualifiedCatchingClassName;
        this.catchingMethodName = catchingMethodName;
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        return this.orgException.getStackTrace();
    }

    public StackTraceElement findCatchingMethod() {
        return this.findCatchingMethod(this.getCatchingClassName(), this.getCatchingMethodName());
    }

    private StackTraceElement findCatchingMethod(String fullyQualifiedClassName, String methodName) {
        StackTraceElement[] stackTrace;
        for (StackTraceElement stackTraceElement : stackTrace = this.getStackTrace()) {
            if (!stackTraceElement.getClassName().equals(fullyQualifiedClassName) || !stackTraceElement.getMethodName().equals(methodName)) continue;
            return stackTraceElement;
        }
        return null;
    }

    public RuntimeException getOrgException() {
        return this.orgException;
    }

    @Override
    public String toString() {
        return this.orgException.toString();
    }

    public String getCatchingClassName() {
        return this.fullyQualifiedCatchingClassName;
    }

    public String getCatchingMethodName() {
        return this.catchingMethodName;
    }

    public Class<?> getThrowingClass() {
        return this.throwingClass;
    }
}

