/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.urcaps.jointposition;

import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.persistence.XmlSerializable;
import com.ur.polyscope.urcaps.domain.value.AngleImpl;
import com.ur.urcap.api.domain.value.jointposition.JointPosition;
import com.ur.urcap.api.domain.value.simple.Angle;

class JointPositionImpl
implements JointPosition,
XmlSerializable {
    private static final String XML_ELEMENT_NAME = "JointPosition";
    private static final String JOINT_POSITION_KEY = "key";
    private static final String JOINT_POSITION_ANGLE_KEY = "pos";
    private final Angle position;
    private Angle angle;
    private long revolutions;

    JointPositionImpl(double position, Angle.Unit unit) {
        this(new AngleImpl(position, unit));
    }

    private JointPositionImpl(Angle position) {
        this.position = position;
        this.setAngleAndRevolution();
    }

    private void setAngleAndRevolution() {
        double angleRemainder = this.position.getAs(Angle.Unit.RAD) % (Math.PI * 2);
        this.revolutions = (long)(this.position.getAs(Angle.Unit.RAD) / (Math.PI * 2));
        this.angle = new AngleImpl(angleRemainder, Angle.Unit.RAD);
    }

    public double getPosition(Angle.Unit unit) {
        return this.position.getAs(unit);
    }

    public long getRevolutions() {
        return this.revolutions;
    }

    public double getAngle(Angle.Unit unit) {
        return this.angle.getAs(unit);
    }

    public boolean epsilonEquals(JointPosition other, double epsilon, Angle.Unit unit) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        return !(Math.abs(this.getPosition(unit) - other.getPosition(unit)) > epsilon);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JointPositionImpl that = (JointPositionImpl)o;
        return this.position != null ? this.position.equals((Object)that.position) : that.position == null;
    }

    public int hashCode() {
        return this.position != null ? this.position.hashCode() : 0;
    }

    public String toString() {
        return String.format("%f rad", this.angle.getAs(Angle.Unit.RAD));
    }

    public void write(PersistWriter writer, String key) {
        writer.startNode(XML_ELEMENT_NAME);
        writer.addAttribute(JOINT_POSITION_KEY, key);
        ((XmlSerializable)this.position).write(writer, JOINT_POSITION_ANGLE_KEY);
        writer.endNode();
    }

    public static boolean canRead(String nodeName) {
        return XML_ELEMENT_NAME.equals(nodeName);
    }

    public static String readKey(PersistReader reader) {
        return reader.getStringAttribute(JOINT_POSITION_KEY);
    }

    public static JointPositionImpl readValue(PersistReader reader) {
        reader.moveToChildNode();
        AngleImpl angle = AngleImpl.readValue(reader);
        reader.moveToParentNode();
        return new JointPositionImpl(angle);
    }
}

