/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.urcaps.jointposition;

import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.persistence.XmlSerializable;
import com.ur.polyscope.urcaps.jointposition.JointPositionImpl;
import com.ur.urcap.api.domain.value.jointposition.JointPosition;
import com.ur.urcap.api.domain.value.jointposition.JointPositions;
import com.ur.urcap.api.domain.value.simple.Angle;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

class JointPositionsImpl
implements JointPositions,
XmlSerializable {
    private static final String XML_ELEMENT_NAME = "JointPositions";
    private static final String JOINT_POSITIONS_KEY = "key";
    private final JointPosition[] jointPositions;

    JointPositionsImpl(double base, double shoulder, double elbow, double wrist1, double wrist2, double wrist3, Angle.Unit unit) {
        this.jointPositions = new JointPosition[]{new JointPositionImpl(base, unit), new JointPositionImpl(shoulder, unit), new JointPositionImpl(elbow, unit), new JointPositionImpl(wrist1, unit), new JointPositionImpl(wrist2, unit), new JointPositionImpl(wrist3, unit)};
    }

    private JointPositionsImpl(JointPosition[] jointPositions) {
        this.jointPositions = jointPositions;
    }

    public JointPosition[] getAllJointPositions() {
        return (JointPosition[])this.jointPositions.clone();
    }

    public boolean equals(Object obj) {
        if (obj instanceof JointPositions) {
            JointPositions other = (JointPositions)obj;
            EqualsBuilder equalsBuilder = new EqualsBuilder();
            equalsBuilder.append((Object[])this.getAllJointPositions(), (Object[])other.getAllJointPositions());
            return equalsBuilder.isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object[])this.jointPositions).toHashCode();
    }

    public boolean epsilonEquals(JointPositions other, double epsilon, Angle.Unit unit) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        JointPosition[] otherJointPositions = other.getAllJointPositions();
        if (this.jointPositions == otherJointPositions) {
            return true;
        }
        if (this.jointPositions == null || otherJointPositions == null) {
            return false;
        }
        if (this.jointPositions.length != otherJointPositions.length) {
            return false;
        }
        return this.comparePositions(other, epsilon, unit);
    }

    private boolean comparePositions(JointPositions other, double epsilon, Angle.Unit unit) {
        JointPosition[] otherJointPositions = other.getAllJointPositions();
        for (int i = 0; i < this.jointPositions.length; ++i) {
            JointPosition thisPos = this.jointPositions[i];
            JointPosition otherPos = otherJointPositions[i];
            if (thisPos == null || otherPos == null) {
                return false;
            }
            if (thisPos.epsilonEquals(otherPos, epsilon, unit)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return Arrays.toString(this.jointPositions);
    }

    public void write(PersistWriter writer, String key) {
        writer.startNode(XML_ELEMENT_NAME);
        writer.addAttribute(JOINT_POSITIONS_KEY, key);
        int i = 0;
        for (JointPosition jp : this.jointPositions) {
            ((XmlSerializable)jp).write(writer, "[" + ++i + "]");
        }
        writer.endNode();
    }

    public static boolean canRead(String nodeName) {
        return XML_ELEMENT_NAME.equals(nodeName);
    }

    public static String readKey(PersistReader reader) {
        return reader.getStringAttribute(JOINT_POSITIONS_KEY);
    }

    public static JointPositionsImpl readValue(PersistReader reader) {
        ArrayList<JointPositionImpl> list = new ArrayList<JointPositionImpl>();
        while (reader.hasMoreNodes()) {
            reader.moveToChildNode();
            list.add(JointPositionImpl.readValue(reader));
            reader.moveToParentNode();
        }
        JointPosition[] posArray = new JointPositionImpl[list.size()];
        posArray = list.toArray(posArray);
        return new JointPositionsImpl(posArray);
    }
}

