/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.urcaps.proxy;

import com.ur.polyscope.urcaps.proxy.SwitchableActionProxyCapable;
import com.ur.polyscope.urcaps.proxy.SwitchableProxyCapable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;

public class SwitchableProxy {
    private SwitchableProxy() {
    }

    public static <T extends SwitchableProxyCapable> T createForwardingProxy(T realObject) {
        SwitchableInvocationHandler handler = new SwitchableInvocationHandler(realObject);
        return (T)((SwitchableProxyCapable)Proxy.newProxyInstance(realObject.getClass().getClassLoader(), realObject.getClass().getInterfaces(), (InvocationHandler)handler));
    }

    public static <T> T createForwardingActionProxy(T realObject) {
        SwitchableInvocationHandler handler = new SwitchableInvocationHandler(realObject);
        return (T)Proxy.newProxyInstance(realObject.getClass().getClassLoader(), realObject.getClass().getInterfaces(), (InvocationHandler)handler);
    }

    public static void switchToAction(Object proxy, Runnable action) {
        InvocationHandler handler = Proxy.getInvocationHandler(proxy);
        if (handler instanceof SwitchableInvocationHandler) {
            if (proxy instanceof SwitchableActionProxyCapable) {
                ((SwitchableActionProxyCapable)proxy).switchToAction(action);
            }
            ((SwitchableInvocationHandler)handler).switchToActionHandler(action);
        }
    }

    public static void switchToIgnore(SwitchableProxyCapable proxy) {
        InvocationHandler handler = Proxy.getInvocationHandler(proxy);
        if (handler instanceof SwitchableInvocationHandler) {
            proxy.switchToIgnore();
            ((SwitchableInvocationHandler)handler).switchToIgnoreHandler();
        }
    }

    private static class SwitchableInvocationHandler
    implements InvocationHandler {
        private final HashMap<Object, Object> defaultValues;
        private InvocationHandler handler;
        private final Object realObject;

        public SwitchableInvocationHandler(Object realObject) {
            this.realObject = realObject;
            this.handler = this.createForwardingHandler(realObject);
            this.defaultValues = new HashMap();
            this.defaultValues.put(Boolean.TYPE, false);
            this.defaultValues.put(Void.TYPE, null);
            this.defaultValues.put(Byte.TYPE, (byte)0);
            this.defaultValues.put(Short.TYPE, (short)0);
            this.defaultValues.put(Integer.TYPE, 0);
            this.defaultValues.put(Long.TYPE, 0L);
            this.defaultValues.put(Float.TYPE, Float.valueOf(0.0f));
            this.defaultValues.put(Double.TYPE, 0.0);
            this.defaultValues.put(Character.TYPE, Character.valueOf('\u0000'));
        }

        public void switchToIgnoreHandler() {
            this.handler = this.createIgnoreVoidMethodsHandler(this.realObject);
        }

        public void switchToActionHandler(Runnable action) {
            this.handler = this.createExecuteActionHandler(action);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return this.handler.invoke(proxy, method, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }

        private <T> InvocationHandler createForwardingHandler(T realObject) {
            return (proxy, method, args) -> method.invoke(realObject, args);
        }

        private <T> InvocationHandler createIgnoreVoidMethodsHandler(T realObject) {
            return (proxy, method, args) -> {
                if (method.getReturnType().equals(Void.TYPE)) {
                    return null;
                }
                return method.invoke(realObject, args);
            };
        }

        private InvocationHandler createExecuteActionHandler(Runnable action) {
            return (proxy, method, args) -> {
                if (action != null) {
                    action.run();
                }
                return this.ignoreMethod(method.getReturnType());
            };
        }

        private Object ignoreMethod(Class<?> methodReturnType) {
            if (methodReturnType.isPrimitive()) {
                return this.defaultValues.get(methodReturnType);
            }
            return null;
        }
    }
}

