/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.urcaps.util;

import com.ur.lang.Defense;
import com.ur.urcap.api.util.Optional;

public final class OptionalImpl<T>
implements Optional<T> {
    private com.ur.util.Optional<T> optional;

    private OptionalImpl() {
        this.optional = com.ur.util.Optional.empty();
    }

    private OptionalImpl(T value) {
        this.optional = com.ur.util.Optional.of(value);
    }

    public static <T> Optional<T> empty() {
        return new OptionalImpl<T>();
    }

    public static <T> Optional<T> of(T value) {
        Defense.notNull(value);
        return new OptionalImpl<T>(value);
    }

    public boolean isPresent() {
        return this.optional.isPresent();
    }

    public T get() {
        return (T)this.optional.get();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Optional)) {
            return false;
        }
        Optional other = (Optional)obj;
        if (this.isPresent() && other.isPresent()) {
            return this.get() == other.get() || this.get().equals(other.get());
        }
        return this.isPresent() == other.isPresent();
    }

    public int hashCode() {
        return this.isPresent() ? this.get().hashCode() : 0;
    }

    public String toString() {
        return this.isPresent() ? String.format("Optional[%s]", this.optional.get()) : "Optional.empty";
    }
}

