/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.profinet.impl.daemon;

import com.ur.polyscope.profinet.impl.daemon.DaemonService;
import com.ur.urcap.api.contribution.DaemonContribution;
import com.ur.util.commandline.BashScriptRunner;
import java.io.IOException;
import javax.inject.Inject;

public class ProfinetDaemonService
implements DaemonService {
    private static final String PROFINET_SERVICE = "urprofinet";
    private static final String SYSTEMCTL_USER = "systemctl";
    private static final String SHOW = "show";
    private static final String ACTIVE_STATE = "-p ActiveState";

    @Inject
    public ProfinetDaemonService() {
    }

    @Override
    public void startService() throws IOException {
        ProfinetDaemonService.runScript("start", PROFINET_SERVICE);
    }

    @Override
    public void stopService() throws IOException {
        ProfinetDaemonService.runScript("stop", PROFINET_SERVICE);
    }

    @Override
    public DaemonContribution.State getState() throws IOException {
        String activeCommand = String.format("%s %s", PROFINET_SERVICE, ACTIVE_STATE);
        BashScriptRunner runner = ProfinetDaemonService.runScript(SHOW, activeCommand);
        String status = runner.getAllString();
        if ("ActiveState=active".equalsIgnoreCase(status = status.replaceAll("\n", ""))) {
            return DaemonContribution.State.RUNNING;
        }
        if ("ActiveState=inactive".equalsIgnoreCase(status)) {
            return DaemonContribution.State.STOPPED;
        }
        return DaemonContribution.State.ERROR;
    }

    private static BashScriptRunner runScript(String command, String argument) throws IOException {
        BashScriptRunner runner = new BashScriptRunner(String.format("%s %s %s", SYSTEMCTL_USER, command, argument), null, null);
        runner.execute();
        return runner;
    }
}

