/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.profinet.impl.installation;

import com.ur.polyscope.profinet.impl.generated.ImageResource;
import com.ur.polyscope.profinet.impl.generated.TextLabels;
import com.ur.polyscope.profinet.impl.installation.ProfinetServiceExt;
import com.ur.polyscope.profinet.impl.xmlrpc.UnknownResponseException;
import com.ur.swing.dialog.ConfirmationDialogCreator;
import com.ur.swing.dialog.ConfirmationMessage;
import com.ur.swing.dialog.DialogHandler;
import com.ur.swing.dialog.OkDialogListener;
import com.ur.util.logging.Log;
import com.ur.util.swing.HTML;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.net.URL;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.apache.xmlrpc.XmlRpcException;

@Singleton
public class DCPSignalListener
extends OkDialogListener {
    private static final String ANIMATED_LED_PATH = "/images/icons/green_led_animated.gif";
    private static final int TEXT_WIDTH = 450;
    private final ProfinetServiceExt profinetServiceExt;
    private final ConfirmationDialogCreator confirmationDialogCreator;
    private final TextLabels textLabels;
    private boolean lastDCPSigal;
    private boolean dialogDismissedByUser;
    private DialogHandler dialogHandler;
    private JLabel dcpMessageLabel;
    private JPanel dialogPanel;
    private ScheduledFuture<?> scheduledFuture;

    @Inject
    public DCPSignalListener(ProfinetServiceExt profinetServiceExt, ConfirmationDialogCreator confirmationDialogCreator, TextLabels textLabels) {
        this.profinetServiceExt = profinetServiceExt;
        this.confirmationDialogCreator = confirmationDialogCreator;
        this.textLabels = textLabels;
        this.initDialogPanel();
    }

    protected void startListeningForDCPSignal() {
        this.stopListeningForDCPSignal();
        ScheduledThreadPoolExecutor executorService = new ScheduledThreadPoolExecutor(1);
        this.scheduledFuture = executorService.scheduleWithFixedDelay(this::updateDCPSignalState, 1L, 1L, TimeUnit.SECONDS);
    }

    protected void stopListeningForDCPSignal() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
        }
        this.updateLastDCPSignalState(false);
        this.setDialogDismissedByUser(false);
        this.closeDcpDialog();
    }

    public void updateDCPSignalState() {
        try {
            boolean newDCPSignal = this.profinetServiceExt.isDCPSignalingRequested();
            if (this.dcpSignalHasChanged(newDCPSignal)) {
                this.showDialogIfDCPSignalEnabled(newDCPSignal);
                this.updateLastDCPSignalState(newDCPSignal);
            }
        }
        catch (UnknownResponseException | XmlRpcException e) {
            Log.warning((String)"PROFINET: Querying for connection state failed: ", (Throwable)e);
        }
    }

    private void showDialogIfDCPSignalEnabled(boolean newDCPSignal) throws XmlRpcException, UnknownResponseException {
        if (newDCPSignal) {
            this.showDialog();
        } else {
            this.closeDialog();
        }
    }

    private void showDialog() throws XmlRpcException, UnknownResponseException {
        this.updateDeviceName();
        EventQueue.invokeLater(this::showDialogIfNotDismissedByUser);
    }

    private void closeDialog() {
        this.setDialogDismissedByUser(false);
        EventQueue.invokeLater(this::closeDcpDialog);
    }

    private boolean dcpSignalHasChanged(boolean newDCPSignal) {
        return this.lastDCPSigal ^ newDCPSignal;
    }

    private void showDialogIfNotDismissedByUser() {
        if (!this.isDialogDismissedByUser()) {
            this.dialogHandler = this.confirmationDialogCreator.showConfirmationDialogWithCustomMessagePanel(this.createDCPDialogMessage(), this.dialogPanel, (OkDialogListener)this);
        }
    }

    private void updateDeviceName() throws XmlRpcException, UnknownResponseException {
        this.dcpMessageLabel.setText(HTML.html((String)HTML.maxWidth((int)450, (String)this.textLabels.dcpDialogDescription(this.profinetServiceExt.getIODeviceName()))));
    }

    private void updateLastDCPSignalState(boolean newDCPSignal) {
        this.lastDCPSigal = newDCPSignal;
    }

    private ConfirmationMessage createDCPDialogMessage() {
        return new ConfirmationMessage("PROFINET DCP Signal", this.textLabels.dcpDialogTitle(), "", this.textLabels.close(), "");
    }

    public void onOkClicked() {
        this.setDialogDismissedByUser(true);
    }

    private void closeDcpDialog() {
        if (this.dialogHandler != null) {
            this.dialogHandler.closeDialog();
        }
    }

    private void initDialogPanel() {
        this.dialogPanel = new JPanel();
        this.dialogPanel.setLayout(new BoxLayout(this.dialogPanel, 1));
        this.dialogPanel.setBorder(new EmptyBorder(15, 15, 15, 15));
        this.dcpMessageLabel = new JLabel(HTML.html((String)HTML.maxWidth((int)450, (String)this.textLabels.dcpDialogDescription(""))), this.getAnimatedLed(), 2);
        JLabel dcpWarningLabel = new JLabel(HTML.html((String)HTML.maxWidth((int)450, (String)this.textLabels.dcpDialogWarning())), ImageResource.warning24(), 2);
        this.dialogPanel.add(this.dcpMessageLabel);
        Dimension fillerDimensions = new Dimension(0, 30);
        this.dialogPanel.add(new Box.Filler(fillerDimensions, fillerDimensions, fillerDimensions));
        this.dialogPanel.add(dcpWarningLabel);
    }

    private Icon getAnimatedLed() {
        Icon icon;
        URL url = DCPSignalListener.class.getResource(ANIMATED_LED_PATH);
        if (url != null) {
            icon = new ImageIcon(new ImageIcon(url).getImage());
        } else {
            Log.error((String)"Could not retrieve animated led");
            icon = ImageResource.greenLed24();
        }
        return icon;
    }

    protected boolean isDialogDismissedByUser() {
        return this.dialogDismissedByUser;
    }

    protected void setDialogDismissedByUser(boolean dialogDismissedByUser) {
        this.dialogDismissedByUser = dialogDismissedByUser;
    }
}

