/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.profinet.impl.installation;

import com.ur.polyscope.profinet.impl.generated.WatchdogAction;
import com.ur.polyscope.profinet.impl.installation.ProfinetServiceExt;
import com.ur.polyscope.profinet.impl.installation.ProfinetSettings;
import com.ur.polyscope.profinet.impl.installation.UIUpdateCallBack;
import com.ur.swing.ComboBox;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

class PLCComboListener
implements ActionListener {
    private final PLCComboModule module;
    private final UIUpdateCallBack uiUpdateCallBack;
    private final ProfinetServiceExt profinetServiceExt;

    public PLCComboListener(ProfinetServiceExt profinetServiceExt, PLCComboModule module, UIUpdateCallBack uiUpdateCallBack) {
        this.profinetServiceExt = profinetServiceExt;
        this.module = module;
        this.uiUpdateCallBack = uiUpdateCallBack;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ComboBox comboBox = (ComboBox)actionEvent.getSource();
        if (!comboBox.hasFocus()) {
            return;
        }
        WatchdogAction watchdogAction = (WatchdogAction)((Object)comboBox.getSelectedItem());
        ProfinetSettings settings = this.profinetServiceExt.getProfinetSettings();
        switch (this.module) {
            case PLC_IO: {
                settings.setPlcIO(watchdogAction);
                break;
            }
            case PLC_REG1: {
                settings.setPlcREG1(watchdogAction);
                break;
            }
            case PLC_REG2: {
                settings.setPlcREG2(watchdogAction);
                break;
            }
        }
        this.uiUpdateCallBack.updateUICallBack();
    }

    static enum PLCComboModule {
        PLC_IO,
        PLC_REG1,
        PLC_REG2;

    }
}

