/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.profinet.impl.installation;

import com.ur.polyscope.java.logger.LogFactory;
import com.ur.polyscope.java.logger.Logger;
import com.ur.polyscope.profinet.impl.generated.ImageResource;
import com.ur.polyscope.profinet.impl.generated.TextLabels;
import com.ur.polyscope.profinet.impl.generated.WatchdogAction;
import com.ur.polyscope.profinet.impl.installation.DaemonStatusMessages;
import com.ur.polyscope.profinet.impl.installation.DisableButtonAction;
import com.ur.polyscope.profinet.impl.installation.EnableButtonAction;
import com.ur.polyscope.profinet.impl.installation.PLCComboListener;
import com.ur.polyscope.profinet.impl.installation.ProfinetServiceExt;
import com.ur.polyscope.profinet.impl.installation.ProfinetSettings;
import com.ur.polyscope.profinet.impl.installation.ProfinetUIStateListener;
import com.ur.polyscope.profinet.impl.installation.UIStateHolder;
import com.ur.polyscope.profinet.impl.installation.UIUpdateCallBack;
import com.ur.polyscope.profinet.impl.installation.WatchDogComboBoxModel;
import com.ur.polyscope.profinet.impl.installation.WatchDogLabelProvider;
import com.ur.polyscope.profinet.impl.xmlrpc.UnknownResponseException;
import com.ur.polyscope.profinet.installation.ProfinetUIState;
import com.ur.swing.CardPanel;
import com.ur.swing.ComboBox;
import com.ur.swing.LabelProvider;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.urcap.api.contribution.DaemonContribution;
import com.ur.util.logging.Log;
import com.ur.util.swing.HTML;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.xmlrpc.XmlRpcException;

@Singleton
public class ProfinetConfigurationTab
extends CardPanel
implements ProfinetUIStateListener,
UIUpdateCallBack {
    private static final String PROFINET_STATUS_ICON_LABEL = "profinetStatusIconLabe";
    private static final String PROFINET_INFO_ICON_LABEL = "profinetInfoIconLabe";
    private static final String PROFINET_STATUS_LABEL = "profinetStatusLabel";
    private static final String PROFINET_ENABLE_BUTTON = "profinetEnableButton";
    private static final String PROFINET_DISBLE_BUTTON = "profineDisbleButton";
    private static final String PROFINET_PLC_IO_COMBOBOX = "profinetPLCIOCombobox";
    private static final String PROFINET_PLC_REG_1_COMBOBOX = "profinetPLCReg1Combobox";
    private static final String PROFINET_PLC_REG_2_COMBOBOX = "profinetPLCReg2Combobox";
    private static final Logger LOG = LogFactory.createLogger(ProfinetConfigurationTab.class);
    private static final Dimension BUTTON_SIZE = new Dimension(250, 40);
    private static final Dimension COMBO_SIZE = new Dimension(150, 29);
    private final TextLabels textLabels;
    private final ProfinetServiceExt profinetServiceExt;
    private final WidgetFactory widgetFactory;
    private final DaemonStatusMessages daemonStatusMessages;
    private final UIStateHolder uiStateHolder;
    private JLabel statusIcon;
    private JButton enableButton;
    private JButton disableButton;
    private JLabel statusLabel;
    private ComboBox plcIOCombo;
    private ComboBox plcReg1Combo;
    private ComboBox plcReg2Combo;
    private Timer uiTimer;
    private JLabel warningStatusLabel;
    private JLabel lockByProfisafeLabel;
    protected JLabel ioDeviceNamelabel;
    private JLabel dcpSignalLabel;
    private boolean shouldShowStatusLabel;

    @Inject
    public ProfinetConfigurationTab(ViewContext viewContext, TextLabels textLabels, ProfinetServiceExt profinetServiceExt, DaemonStatusMessages daemonStatusMessages, UIStateHolder uiStateHolder) {
        this.textLabels = textLabels;
        this.profinetServiceExt = profinetServiceExt;
        this.widgetFactory = viewContext.createWidgetFactory();
        this.daemonStatusMessages = daemonStatusMessages;
        this.uiStateHolder = uiStateHolder;
        this.initComponents();
    }

    @Override
    public void updateUICallBack() {
        this.updateComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.add(this.createPageHeader(), "North");
        this.add(this.createIndentationPanel(), "Center");
    }

    private JPanel createPageHeader() {
        this.statusIcon = this.widgetFactory.createLabel(ImageResource.grayLed24());
        this.statusIcon.setName(PROFINET_STATUS_ICON_LABEL);
        JLabel staticStatusLabel = this.widgetFactory.createPageTitle(String.valueOf(this.textLabels.profinetIODevice()) + ":");
        this.statusLabel = this.widgetFactory.createPageTitle(this.textLabels.statusDaemonNotRunning());
        this.statusLabel.setName(PROFINET_STATUS_LABEL);
        JPanel pageHeaderPanel = new JPanel(new FlowLayout(3));
        pageHeaderPanel.add(this.statusIcon);
        pageHeaderPanel.add(staticStatusLabel);
        pageHeaderPanel.add(Box.createHorizontalStrut(5));
        pageHeaderPanel.add(this.statusLabel);
        return pageHeaderPanel;
    }

    private JPanel createIndentationPanel() {
        JPanel indentationPanel = new JPanel(new BorderLayout());
        indentationPanel.add(Box.createHorizontalStrut(28), "West");
        indentationPanel.add((Component)this.createButtonsActionsDescriptionsPanel(), "Center");
        return indentationPanel;
    }

    private JPanel createButtonsActionsDescriptionsPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.leftAlignWithFlow(this.createInfoMessagesPanel()), "North");
        panel.add((Component)this.createButtonsActionsDescriptions(), "Center");
        return panel;
    }

    private JPanel createInfoMessagesPanel() {
        JPanel infoMessagesPanel = new JPanel();
        infoMessagesPanel.setLayout(new BoxLayout(infoMessagesPanel, 3));
        this.ioDeviceNamelabel = this.widgetFactory.createLabel(this.textLabels.ioDeviceName());
        this.dcpSignalLabel = this.widgetFactory.createLabel(this.textLabels.dcpIdentification(""));
        this.dcpSignalLabel.setIcon(ImageResource.informationIcon24());
        this.dcpSignalLabel.setVisible(false);
        JPanel dcpSignalPanel = new JPanel(new BorderLayout());
        dcpSignalPanel.add((Component)this.dcpSignalLabel, "West");
        dcpSignalPanel.add(Box.createVerticalStrut(24), "East");
        this.lockByProfisafeLabel = this.widgetFactory.createLabel(this.textLabels.screenIsLocked());
        this.lockByProfisafeLabel.setIcon(ImageResource.informationIcon24());
        this.lockByProfisafeLabel.setVisible(false);
        infoMessagesPanel.add(this.leftAlignWithFlow(this.ioDeviceNamelabel));
        infoMessagesPanel.add(Box.createVerticalStrut(10));
        infoMessagesPanel.add(this.leftAlignWithFlow(dcpSignalPanel));
        infoMessagesPanel.add(this.leftAlignWithFlow(this.lockByProfisafeLabel));
        return infoMessagesPanel;
    }

    private JPanel createWarningPanel() {
        JPanel warningPanel = new JPanel(new BorderLayout());
        this.warningStatusLabel = new JLabel();
        this.warningStatusLabel.setIcon(ImageResource.warning24());
        this.warningStatusLabel.setVerticalTextPosition(1);
        warningPanel.add((Component)this.warningStatusLabel, "West");
        return this.leftAlignWithFlow(warningPanel);
    }

    private JPanel createButtonsActionsDescriptions() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.createButtonsPanel(), "North");
        panel.add((Component)this.createActionsDescriptionsPanel(), "Center");
        return panel;
    }

    private JPanel createButtonsPanel() {
        this.enableButton = this.widgetFactory.createButton((Action)new EnableButtonAction(this.textLabels, this.profinetServiceExt, this));
        this.enableButton.setName(PROFINET_ENABLE_BUTTON);
        this.setComponentSizes(this.enableButton, BUTTON_SIZE);
        this.disableButton = this.widgetFactory.createButton((Action)new DisableButtonAction(this.textLabels, this.profinetServiceExt, this));
        this.disableButton.setName(PROFINET_DISBLE_BUTTON);
        this.setComponentSizes(this.disableButton, BUTTON_SIZE);
        JPanel buttonsPanel = new JPanel(new FlowLayout(3));
        buttonsPanel.add(this.enableButton);
        buttonsPanel.add(Box.createHorizontalStrut(8));
        buttonsPanel.add(this.disableButton);
        return buttonsPanel;
    }

    private JPanel createActionsDescriptionsPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.createActionsPanel(), "North");
        panel.add((Component)this.createDescriptionWarningPanel(), "Center");
        return panel;
    }

    private JPanel createActionsPanel() {
        JPanel actionsPanel = new JPanel(new BorderLayout());
        actionsPanel.add((Component)this.createInformationTextPanel(), "North");
        actionsPanel.add((Component)this.createActionDescriptionTextPanel(), "Center");
        actionsPanel.add((Component)this.createDropDownPanel(), "South");
        return actionsPanel;
    }

    private JPanel createInformationTextPanel() {
        JLabel infoLabel = this.widgetFactory.createLabel(this.textLabels.warningEnableServiceMessageLabel());
        infoLabel.setIcon(ImageResource.informationIcon24());
        infoLabel.setName(PROFINET_INFO_ICON_LABEL);
        JPanel infoPanel = new JPanel();
        BoxLayout boxLayout = new BoxLayout(infoPanel, 0);
        infoPanel.setLayout(boxLayout);
        infoPanel.add(this.leftAlignWithFlow(infoLabel));
        return infoPanel;
    }

    private JPanel createActionDescriptionTextPanel() {
        JLabel watchdogActionlabel = this.widgetFactory.createLabel(this.textLabels.watchdogActionLabel());
        JLabel descriptionLabel = this.widgetFactory.createLabel(this.textLabels.installationScreenDescription());
        JPanel actionTextPanel = new JPanel();
        BoxLayout boxLayout = new BoxLayout(actionTextPanel, 3);
        actionTextPanel.setLayout(boxLayout);
        actionTextPanel.add(this.leftAlignWithFlow(descriptionLabel));
        actionTextPanel.add(Box.createVerticalStrut(50));
        actionTextPanel.add(this.leftAlignWithFlow(watchdogActionlabel));
        return actionTextPanel;
    }

    private JPanel createDropDownPanel() {
        this.plcIOCombo = this.widgetFactory.createComboBox((LabelProvider)new WatchDogLabelProvider(this.textLabels), (Object[])new WatchdogAction[0]);
        this.plcIOCombo.setName(PROFINET_PLC_IO_COMBOBOX);
        this.plcIOCombo.addActionListener((ActionListener)new PLCComboListener(this.profinetServiceExt, PLCComboListener.PLCComboModule.PLC_IO, this));
        this.plcIOCombo.setModel((ComboBoxModel)((Object)new WatchDogComboBoxModel()));
        this.setComponentSizes((JComponent)this.plcIOCombo, COMBO_SIZE);
        this.plcReg1Combo = this.widgetFactory.createComboBox((LabelProvider)new WatchDogLabelProvider(this.textLabels), (Object[])new WatchdogAction[0]);
        this.plcReg1Combo.setName(PROFINET_PLC_REG_1_COMBOBOX);
        this.plcReg1Combo.addActionListener((ActionListener)new PLCComboListener(this.profinetServiceExt, PLCComboListener.PLCComboModule.PLC_REG1, this));
        this.plcReg1Combo.setModel((ComboBoxModel)((Object)new WatchDogComboBoxModel()));
        this.setComponentSizes((JComponent)this.plcReg1Combo, COMBO_SIZE);
        this.plcReg2Combo = this.widgetFactory.createComboBox((LabelProvider)new WatchDogLabelProvider(this.textLabels), (Object[])new WatchdogAction[0]);
        this.plcReg2Combo.setName(PROFINET_PLC_REG_2_COMBOBOX);
        this.plcReg2Combo.addActionListener((ActionListener)new PLCComboListener(this.profinetServiceExt, PLCComboListener.PLCComboModule.PLC_REG2, this));
        this.plcReg2Combo.setModel((ComboBoxModel)((Object)new WatchDogComboBoxModel()));
        this.setComponentSizes((JComponent)this.plcReg2Combo, COMBO_SIZE);
        JLabel plcIOModulelabel = this.widgetFactory.createLabel(this.textLabels.ioModule());
        JLabel plcReg1Label = this.widgetFactory.createLabel(String.valueOf(this.textLabels.regModule()) + " 1");
        JLabel plcReg2Label = this.widgetFactory.createLabel(String.valueOf(this.textLabels.regModule()) + " 2");
        JPanel comboAndTextPanel = new JPanel(new FlowLayout(0, 0, 0));
        comboAndTextPanel.add(this.createComboWithLabelPanel(this.plcIOCombo, plcIOModulelabel));
        comboAndTextPanel.add(this.createComboWithLabelPanel(this.plcReg1Combo, plcReg1Label));
        comboAndTextPanel.add(this.createComboWithLabelPanel(this.plcReg2Combo, plcReg2Label));
        return comboAndTextPanel;
    }

    private JPanel createComboWithLabelPanel(ComboBox comboBox, JLabel label) {
        JPanel comboLabelPanel = new JPanel();
        comboLabelPanel.setLayout(new BoxLayout(comboLabelPanel, 3));
        comboLabelPanel.add(this.leftAlignWithFlow(label));
        comboLabelPanel.add(this.leftAlignWithFlow((JComponent)comboBox));
        return comboLabelPanel;
    }

    private JPanel createDescriptionWarningPanel() {
        JPanel descriptionPanel = new JPanel();
        descriptionPanel.setLayout(new BoxLayout(descriptionPanel, 3));
        descriptionPanel.add(this.leftAlignWithFlow(this.createWarningPanel()));
        return descriptionPanel;
    }

    private void setComponentSizes(JComponent component, Dimension dimension) {
        component.setMinimumSize(dimension);
        component.setPreferredSize(dimension);
        component.setMaximumSize(dimension);
    }

    private JPanel leftAlignWithFlow(JComponent component) {
        JPanel leftAlignedPanel = new JPanel(new FlowLayout(0));
        leftAlignedPanel.add(component);
        return leftAlignedPanel;
    }

    @Override
    public void stateChanged(UIStateHolder stateHolder) {
        this.updateComponents();
    }

    public void enter(Object o) {
        super.enter(o);
        this.uiTimer = new Timer(true);
        this.uiTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                EventQueue.invokeLater(() -> ProfinetConfigurationTab.this.updateComponents());
            }
        }, 500L, 1000L);
        this.updateComponents();
    }

    public Object exit() {
        if (this.uiTimer != null) {
            this.uiTimer.cancel();
            this.uiTimer = null;
        }
        return super.exit();
    }

    public void updateComponents() {
        ProfinetSettings settings = this.profinetServiceExt.getProfinetSettings();
        this.enableButton.setEnabled(!settings.isEnabled() && this.uiStateEnabled());
        this.disableButton.setEnabled(settings.isEnabled() && this.uiStateEnabled());
        this.updatePageHeader();
        this.updateComboBoxes();
        String deviceName = this.getDeviceName();
        this.updateInformationText(deviceName);
        this.updateLockedByText();
        this.updateDCPSignalInfoLabel(deviceName);
    }

    private String getDeviceName() {
        try {
            return this.profinetServiceExt.getIODeviceName();
        }
        catch (UnknownResponseException | XmlRpcException e) {
            ProfinetConfigurationTab.logConnectionException((Exception)e);
            return "";
        }
    }

    private boolean uiStateEnabled() {
        return ProfinetUIState.ENABLED.equals((Object)this.uiStateHolder.getCurrentUIState());
    }

    private void updatePageHeader() {
        switch (this.profinetServiceExt.getDaemonState()) {
            case RUNNING: {
                if (this.isConnected()) {
                    this.statusLabel.setText(this.textLabels.statusConnectedToProfinetController());
                    this.statusIcon.setIcon(ImageResource.greenLed24());
                    break;
                }
                this.statusLabel.setText(this.textLabels.statusDaemonRunning());
                this.statusIcon.setIcon(ImageResource.yellowLed24());
                break;
            }
            case STOPPED: {
                if (!this.profinetServiceExt.getProfinetSettings().isEnabled()) {
                    this.statusLabel.setText(this.textLabels.statusDisabled());
                    this.statusIcon.setIcon(ImageResource.grayLed24());
                    break;
                }
                this.statusLabel.setText(this.textLabels.statusDaemonNotRunning());
                this.statusIcon.setIcon(ImageResource.redLed24());
                break;
            }
            case ERROR: {
                if (this.profinetServiceExt.getProfinetSettings().isEnabled()) {
                    this.statusLabel.setText(this.textLabels.statusDaemonError());
                    this.statusIcon.setIcon(ImageResource.redLed24());
                    break;
                }
                this.statusLabel.setText(this.textLabels.statusDisabled());
                this.statusIcon.setIcon(ImageResource.grayLed24());
                break;
            }
        }
    }

    private void updateComboBoxes() {
        ProfinetSettings settings = this.profinetServiceExt.getProfinetSettings();
        this.plcIOCombo.setSelectedItem((Object)settings.getPlcIO());
        this.plcIOCombo.setEnabled(settings.isEnabled() && this.uiStateEnabled());
        this.plcReg1Combo.setSelectedItem((Object)settings.getPlcREG1());
        this.plcReg1Combo.setEnabled(settings.isEnabled() && this.uiStateEnabled());
        this.plcReg2Combo.setSelectedItem((Object)settings.getPlcREG2());
        this.plcReg2Combo.setEnabled(settings.isEnabled() && this.uiStateEnabled());
    }

    private void updateInformationText(String deviceName) {
        ProfinetSettings settings = this.profinetServiceExt.getProfinetSettings();
        this.shouldShowStatusLabel = false;
        String prev = this.warningStatusLabel.getText();
        StringBuilder statusMessageStringBuilder = this.createStatusMessageStringBuilder();
        this.appendStatusMessages(statusMessageStringBuilder, this.getStatusMessages(settings));
        if (settings.isEnabled() && this.isRunning()) {
            try {
                this.ioDeviceNamelabel.setText(String.valueOf(this.textLabels.ioDeviceName()) + " " + deviceName);
                this.appendWarningIfModuleConfiguredButNotConnected(statusMessageStringBuilder, this.getModuleStates());
            }
            catch (UnknownResponseException | XmlRpcException e) {
                ProfinetConfigurationTab.logConnectionException((Exception)e);
            }
        } else {
            this.clearDeviceName();
        }
        statusMessageStringBuilder.append("</ul>").append("</html>");
        this.updateWarningStatusLabelIfTextHasChanged(prev, statusMessageStringBuilder);
        this.setWarningStatusLabelVisibleIfStatusTextShouldBeShown();
    }

    private StringBuilder createStatusMessageStringBuilder() {
        return new StringBuilder("<html>").append(this.textLabels.warningHeader()).append("<ul>");
    }

    private void appendStatusMessages(StringBuilder statusMessageStringBuilder, List<String> statusMessages) {
        for (String str : statusMessages) {
            statusMessageStringBuilder.append(HTML.li((String)str));
            this.shouldShowStatusLabel = true;
        }
    }

    private List<Boolean> getModuleStates() throws XmlRpcException, UnknownResponseException {
        List<Boolean> moduleStates = new DummyBooleanArrayList();
        if (this.isConnected()) {
            moduleStates = this.profinetServiceExt.getPluggableModuleStates();
        }
        return moduleStates;
    }

    private void appendWarningIfModuleConfiguredButNotConnected(StringBuilder statusMessageStringBuilder, List<Boolean> moduleStates) {
        if (!moduleStates.get(0).booleanValue() && !WatchdogAction.IGNORE.equals(this.plcIOCombo.getSelectedItem())) {
            statusMessageStringBuilder.append(HTML.li((String)this.textLabels.warningPLCIOModuleNotPLuggedIn()));
            this.shouldShowStatusLabel = true;
        }
        if (!moduleStates.get(1).booleanValue() && !WatchdogAction.IGNORE.equals(this.plcReg1Combo.getSelectedItem()) || !moduleStates.get(2).booleanValue() && !WatchdogAction.IGNORE.equals(this.plcReg2Combo.getSelectedItem())) {
            statusMessageStringBuilder.append(HTML.li((String)this.textLabels.warningPLCREGModuleNotPLuggedIn()));
            this.shouldShowStatusLabel = true;
        }
    }

    private void updateWarningStatusLabelIfTextHasChanged(String prev, StringBuilder sb) {
        if (!sb.toString().equals(prev)) {
            this.warningStatusLabel.setText(sb.toString());
        }
    }

    private void setWarningStatusLabelVisibleIfStatusTextShouldBeShown() {
        if (this.warningStatusLabel.isVisible() != this.shouldShowStatusLabel) {
            this.warningStatusLabel.setVisible(this.shouldShowStatusLabel);
        }
    }

    private void clearDeviceName() {
        this.ioDeviceNamelabel.setText(this.textLabels.ioDeviceName());
    }

    private void updateLockedByText() {
        this.lockByProfisafeLabel.setVisible(ProfinetUIState.DISABLED.equals((Object)this.uiStateHolder.getCurrentUIState()));
    }

    private void updateDCPSignalInfoLabel(String deviceName) {
        try {
            this.dcpSignalLabel.setVisible(this.profinetServiceExt.getProfinetSettings().isEnabled() && this.profinetServiceExt.isDCPSignalingRequested());
            this.dcpSignalLabel.setText(this.textLabels.dcpIdentification(deviceName));
        }
        catch (UnknownResponseException | XmlRpcException e) {
            ProfinetConfigurationTab.logConnectionException((Exception)e);
        }
    }

    private boolean isRunning() {
        return this.profinetServiceExt.getDaemonState() == DaemonContribution.State.RUNNING;
    }

    private ConnectionStatus getConnectionStatus() {
        try {
            if (this.profinetServiceExt.getProfinetSettings().isEnabled()) {
                return this.profinetServiceExt.isConnected() ? ConnectionStatus.CONNECTED : ConnectionStatus.NOT_CONNECTED;
            }
            return ConnectionStatus.NOT_CONNECTED;
        }
        catch (UnknownResponseException | XmlRpcException e) {
            Log.warning((String)"PROFINET: Querying for connection state failed", (Throwable)e);
            return ConnectionStatus.UNKNOWN;
        }
    }

    private boolean isConnected() {
        return this.getConnectionStatus() == ConnectionStatus.CONNECTED;
    }

    private List<String> getStatusMessages(ProfinetSettings settings) {
        try {
            if (settings.isEnabled()) {
                List<Integer> msgCodes = this.profinetServiceExt.getStatusMessages();
                ArrayList<String> res = new ArrayList<String>();
                for (Integer i : msgCodes) {
                    res.add(this.daemonStatusMessages.getStatusMessage(i));
                }
                return res;
            }
        }
        catch (UnknownResponseException | XmlRpcException e) {
            ProfinetConfigurationTab.logConnectionException((Exception)e);
        }
        return new ArrayList<String>();
    }

    private static void logConnectionException(Exception e) {
        String logTrace = "PROFINET: Querying for connection state failed:";
        LOG.trace(logTrace, (Throwable)e);
    }

    ComboBox getPlcIOCombo() {
        return this.plcIOCombo;
    }

    ComboBox getPlcReg1Combo() {
        return this.plcReg1Combo;
    }

    ComboBox getPlcReg2Combo() {
        return this.plcReg2Combo;
    }

    JButton getDisableButton() {
        return this.disableButton;
    }

    JButton getEnableButton() {
        return this.enableButton;
    }

    JLabel getStatusIcon() {
        return this.statusIcon;
    }

    JLabel getStatusLabel() {
        return this.statusLabel;
    }

    private static enum ConnectionStatus {
        UNKNOWN,
        NOT_CONNECTED,
        CONNECTED;

    }

    private static class DummyBooleanArrayList
    extends ArrayList<Boolean> {
        public DummyBooleanArrayList() {
            this.add(false);
            this.add(false);
            this.add(false);
        }
    }
}

