/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.profinet.impl.installation;

import com.ur.polyscope.installation.InstallationComponentConversionStrategy;
import com.ur.polyscope.persistence.ConversionStrategyTemplate;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.profinet.impl.generated.WatchdogAction;
import com.ur.polyscope.profinet.impl.installation.ProfinetServiceExt;
import com.ur.polyscope.profinet.impl.installation.ProfinetSettings;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;

public class ProfinetConversionStrategy
extends ConversionStrategyTemplate<ProfinetSettings>
implements InstallationComponentConversionStrategy<ProfinetSettings> {
    static final String ENABLED = "enabled";
    static final String PLCIO = "PLCIO";
    static final String PLCREG_1 = "PLCREG1";
    static final String PLCREG_2 = "PLCREG2";
    static final String PROFINET = "Profinet";
    private final ProfinetServiceExt profinetServiceExt;

    @Inject
    public ProfinetConversionStrategy(ProfinetServiceExt profinetServiceExt) {
        super(ProfinetSettings.class);
        this.profinetServiceExt = profinetServiceExt;
    }

    public void marshal(ProfinetSettings profinetSettings, PersistWriter persistWriter) {
        persistWriter.addAttribute(ENABLED, profinetSettings.isEnabled());
        persistWriter.addAttribute(PLCIO, (Enum)profinetSettings.getPlcIO());
        persistWriter.addAttribute(PLCREG_1, (Enum)profinetSettings.getPlcREG1());
        persistWriter.addAttribute(PLCREG_2, (Enum)profinetSettings.getPlcREG2());
    }

    public ProfinetSettings unmarshal(PersistReader persistReader) {
        ProfinetSettings result = new ProfinetSettings(this.profinetServiceExt);
        result.loadEnabled(persistReader.getBooleanAttribute(ENABLED));
        result.loadPlcIO((WatchdogAction)persistReader.getEnumAttribute(PLCIO, WatchdogAction.class));
        result.loadPlcREG1((WatchdogAction)persistReader.getEnumAttribute(PLCREG_1, WatchdogAction.class));
        result.loadPlcREG2((WatchdogAction)persistReader.getEnumAttribute(PLCREG_2, WatchdogAction.class));
        return result;
    }

    public Map<String, Class<? extends ProfinetSettings>> getClassAliases(boolean forMarshalling) {
        LinkedHashMap<String, Class<? extends ProfinetSettings>> aliasMap = new LinkedHashMap<String, Class<? extends ProfinetSettings>>();
        aliasMap.put(PROFINET, ProfinetSettings.class);
        return aliasMap;
    }
}

