/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.profinet.impl.installation;

import com.ur.polyscope.installation.domain.UnderwayInstallationProvider;
import com.ur.polyscope.persistence.TypedOptionsSection;
import com.ur.polyscope.profinet.daemon.ProfinetDaemonState;
import com.ur.polyscope.profinet.impl.daemon.DaemonService;
import com.ur.polyscope.profinet.impl.generated.WatchdogAction;
import com.ur.polyscope.profinet.impl.installation.DCPSignalListener;
import com.ur.polyscope.profinet.impl.installation.ProfinetServiceExt;
import com.ur.polyscope.profinet.impl.installation.ProfinetSettings;
import com.ur.polyscope.profinet.impl.installation.UIStateHolder;
import com.ur.polyscope.profinet.impl.xmlrpc.Profinet;
import com.ur.polyscope.profinet.impl.xmlrpc.UnknownResponseException;
import com.ur.polyscope.profinet.installation.ProfinetService;
import com.ur.polyscope.profinet.installation.ProfinetUIState;
import com.ur.urcap.api.contribution.DaemonContribution;
import com.ur.util.logging.Log;
import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import org.apache.xmlrpc.XmlRpcException;

public class ProfinetServiceImpl
implements ProfinetService,
ProfinetServiceExt {
    private static final String PROFINET_SERVICE = "urprofinet";
    protected static final String WATCHDOG_ACTION_PLC_IO_ID = "watchdogActionPLCIO";
    protected static final String WATCHDOG_ACTION_PLC_REG1_ID = "watchdogActionPLCREG1";
    protected static final String WATCHDOG_ACTION_PLC_REG2_ID = "watchdogActionPLCREG2";
    protected static final String UN_SET = "UN_SET";
    protected static final String ENABLED_KEY = "enabled";
    private final UIStateHolder uiStateHolder;
    private final UnderwayInstallationProvider underwayInstallationProvider;
    private final Profinet profinet;
    private final DaemonService daemonService;
    private DCPSignalListener dcpSignalListener;

    @Inject
    public ProfinetServiceImpl(UIStateHolder uiStateHolder, UnderwayInstallationProvider underwayInstallationProvider, Profinet profinet, DaemonService daemonService, DCPSignalListener dcpSignalListener) {
        this.uiStateHolder = uiStateHolder;
        this.underwayInstallationProvider = underwayInstallationProvider;
        this.profinet = profinet;
        this.daemonService = daemonService;
        this.dcpSignalListener = dcpSignalListener;
    }

    public ProfinetDaemonState getProfinetDaemonState() {
        try {
            switch (this.getDaemonState()) {
                case RUNNING: {
                    if (this.profinet.isConnected()) {
                        return ProfinetDaemonState.RUNNING;
                    }
                    return ProfinetDaemonState.CONNECTING;
                }
                case STOPPED: {
                    if (this.getProfinetSettings().isEnabled()) {
                        return ProfinetDaemonState.STARTING;
                    }
                    return ProfinetDaemonState.STOPPED;
                }
            }
            return ProfinetDaemonState.ERROR;
        }
        catch (XmlRpcException e) {
            Log.error((String)"XMLRPC Connection Error", (Throwable)e);
        }
        catch (UnknownResponseException e) {
            Log.error((String)"Unknown XMLRPC Response", (Throwable)e);
        }
        return ProfinetDaemonState.ERROR;
    }

    public ProfinetUIState getProfinetUIState() {
        return this.uiStateHolder.getCurrentUIState();
    }

    public void setProfinetUIState(ProfinetUIState newUIstate) {
        if (ProfinetUIState.DISABLED.equals((Object)newUIstate)) {
            this.setProfinetSettingsToIgnored();
        }
        this.uiStateHolder.setCurrentUIState(newUIstate);
    }

    private void setProfinetSettingsToIgnored() {
        ProfinetSettings setting = this.getProfinetSettings();
        setting.loadPlcIO(WatchdogAction.IGNORE);
        setting.loadPlcREG1(WatchdogAction.IGNORE);
        setting.loadPlcREG2(WatchdogAction.IGNORE);
    }

    public void loadLegacyProfinetSettings(TypedOptionsSection typedOptionsSection) {
        ProfinetSettings profinetSettings = this.getProfinetSettings();
        profinetSettings.loadEnabled(typedOptionsSection.getBoolean(ENABLED_KEY, Boolean.valueOf(false)));
        profinetSettings.loadPlcIO(this.getWatchdogAction(WATCHDOG_ACTION_PLC_IO_ID, typedOptionsSection));
        profinetSettings.loadPlcREG1(this.getWatchdogAction(WATCHDOG_ACTION_PLC_REG1_ID, typedOptionsSection));
        profinetSettings.loadPlcREG2(this.getWatchdogAction(WATCHDOG_ACTION_PLC_REG2_ID, typedOptionsSection));
    }

    public void enableProfinetService() {
        this.getProfinetSettings().setEnabled(true);
    }

    @Override
    public ProfinetSettings getProfinetSettings() {
        return (ProfinetSettings)this.underwayInstallationProvider.getUnderwayInstallation().getComponent(ProfinetSettings.class);
    }

    private WatchdogAction getWatchdogAction(String idKey, TypedOptionsSection typedOptionsSection) {
        WatchdogAction result = WatchdogAction.PAUSE;
        String watchdogActionName = typedOptionsSection.getString(idKey, UN_SET);
        if (watchdogActionName.equals(UN_SET)) {
            result = WatchdogAction.IGNORE;
        } else {
            try {
                result = WatchdogAction.valueOf(watchdogActionName);
            }
            catch (IllegalArgumentException e) {
                Log.error((String)("PROFINET: Watchdog action " + watchdogActionName + " not recognized"), (Throwable)e);
            }
        }
        return result;
    }

    @Override
    public void startProfinetDaemon() {
        try {
            this.daemonService.startService();
            this.dcpSignalListener.startListeningForDCPSignal();
        }
        catch (IOException e) {
            Log.error((String)"Failed to start service urprofinet", (Throwable)e);
        }
    }

    @Override
    public void stopProfinetDaemon() {
        try {
            if (this.getProfinetUIState() == ProfinetUIState.ENABLED) {
                this.daemonService.stopService();
                this.dcpSignalListener.stopListeningForDCPSignal();
            }
        }
        catch (IOException e) {
            Log.error((String)"Failed to stop service urprofinet", (Throwable)e);
        }
    }

    @Override
    public DaemonContribution.State getDaemonState() {
        try {
            return this.daemonService.getState();
        }
        catch (IOException e) {
            Log.error((String)"Failed to get status of urprofinet service", (Throwable)e);
            return DaemonContribution.State.ERROR;
        }
    }

    @Override
    public boolean isConnected() throws XmlRpcException, UnknownResponseException {
        return this.profinet.isConnected();
    }

    @Override
    public String getIODeviceName() throws XmlRpcException, UnknownResponseException {
        return this.profinet.getIODeviceName();
    }

    @Override
    public String getIPAddress() throws XmlRpcException, UnknownResponseException {
        return this.profinet.getIPAddress();
    }

    @Override
    public List<Integer> getStatusMessages() throws XmlRpcException, UnknownResponseException {
        return this.profinet.getStatusMessages();
    }

    @Override
    public List<Boolean> getPluggableModuleStates() throws XmlRpcException, UnknownResponseException {
        return this.profinet.getPluggableModuleStates();
    }

    @Override
    public boolean isDCPSignalingRequested() throws XmlRpcException, UnknownResponseException {
        return this.profinet.isDCPSignalingRequested();
    }
}

